/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.actions;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.urbanairship.api.push.model.PushModelObject;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TagActionData
extends PushModelObject {
    public static TagActionData single(String tag) {
        Preconditions.checkNotNull((Object)tag, (Object)"tag should not be null.");
        return new SingleTag(tag);
    }

    public static TagActionData set(Set<String> tags) {
        Preconditions.checkNotNull(tags, (Object)"tags should not be null.");
        return new TagList(tags);
    }

    public abstract boolean isSingle();

    public abstract String getSingleTag();

    public abstract Set<String> getTagSet();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TagList
    extends TagActionData {
        private final Set<String> tags;

        private TagList(Set<String> tags) {
            this.tags = ImmutableSet.copyOf(tags);
        }

        @Override
        public boolean isSingle() {
            return false;
        }

        public String toString() {
            return "TagList{tags=" + this.tags + '}';
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.tags});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TagList other = (TagList)obj;
            return Objects.equal(this.tags, other.tags);
        }

        @Override
        public String getSingleTag() {
            throw new IllegalStateException("Can't call 'getTag' on a tag list.");
        }

        @Override
        public Set<String> getTagSet() {
            return this.tags;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SingleTag
    extends TagActionData {
        private final String tag;

        private SingleTag(String tag) {
            this.tag = tag;
        }

        @Override
        public boolean isSingle() {
            return true;
        }

        @Override
        public String getSingleTag() {
            return this.tag;
        }

        @Override
        public Set<String> getTagSet() {
            throw new IllegalStateException("Can't call 'getTags' on single tag.");
        }

        public String toString() {
            return "SingleTag{tag='" + this.tag + '\'' + '}';
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.tag});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SingleTag other = (SingleTag)obj;
            return Objects.equal((Object)this.tag, (Object)other.tag);
        }
    }
}

