/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.adm;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.push.model.DeviceType;
import com.urbanairship.api.push.model.PushExpiry;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.DevicePayloadOverride;
import com.urbanairship.api.push.model.notification.Interactive;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ADMDevicePayload
extends PushModelObject
implements DevicePayloadOverride {
    private final Optional<String> alert;
    private final Optional<String> consolidationKey;
    private final Optional<PushExpiry> expiresAfter;
    private final Optional<ImmutableMap<String, String>> extra;
    private final Optional<Interactive> interactive;

    private ADMDevicePayload(Optional<String> alert, Optional<String> consolidationKey, Optional<PushExpiry> expiresAfter, Optional<ImmutableMap<String, String>> extra, Optional<Interactive> interactive) {
        this.alert = alert;
        this.consolidationKey = consolidationKey;
        this.expiresAfter = expiresAfter;
        this.extra = extra;
        this.interactive = interactive;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.AMAZON;
    }

    @Override
    public Optional<String> getAlert() {
        return this.alert;
    }

    public Optional<String> getConsolidationKey() {
        return this.consolidationKey;
    }

    public Optional<PushExpiry> getExpiresAfter() {
        return this.expiresAfter;
    }

    public Optional<ImmutableMap<String, String>> getExtra() {
        return this.extra;
    }

    public Optional<Interactive> getInteractive() {
        return this.interactive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ADMDevicePayload that = (ADMDevicePayload)o;
        if (this.alert != null ? !this.alert.equals(that.alert) : that.alert != null) {
            return false;
        }
        if (this.consolidationKey != null ? !this.consolidationKey.equals(that.consolidationKey) : that.consolidationKey != null) {
            return false;
        }
        if (this.expiresAfter != null ? !this.expiresAfter.equals(that.expiresAfter) : that.expiresAfter != null) {
            return false;
        }
        if (this.extra != null ? !this.extra.equals(that.extra) : that.extra != null) {
            return false;
        }
        return !(this.interactive != null ? !this.interactive.equals(that.interactive) : that.extra != null);
    }

    public int hashCode() {
        int result = this.alert != null ? this.alert.hashCode() : 0;
        result = 31 * result + (this.consolidationKey != null ? this.consolidationKey.hashCode() : 0);
        result = 31 * result + (this.expiresAfter != null ? this.expiresAfter.hashCode() : 0);
        result = 31 * result + (this.extra != null ? this.extra.hashCode() : 0);
        result = 31 * result + (this.interactive != null ? this.interactive.hashCode() : 0);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private String alert = null;
        private String consolidationKey = null;
        private PushExpiry expiresAfter = null;
        private ImmutableMap.Builder<String, String> extra = null;
        private Interactive interactive = null;

        private Builder() {
        }

        public Builder setAlert(String alert) {
            this.alert = alert;
            return this;
        }

        public Builder setConsolidationKey(String consolidationKey) {
            this.consolidationKey = consolidationKey;
            return this;
        }

        public Builder setExpiresAfter(PushExpiry value) {
            this.expiresAfter = value;
            return this;
        }

        public Builder addExtraEntry(String key, String value) {
            if (this.extra == null) {
                this.extra = ImmutableMap.builder();
            }
            this.extra.put((Object)key, (Object)value);
            return this;
        }

        public Builder addAllExtraEntries(Map<String, String> entries) {
            if (this.extra == null) {
                this.extra = ImmutableMap.builder();
            }
            this.extra.putAll(entries);
            return this;
        }

        public Builder setInteractive(Interactive value) {
            this.interactive = value;
            return this;
        }

        public ADMDevicePayload build() {
            return new ADMDevicePayload(Optional.fromNullable((Object)this.alert), Optional.fromNullable((Object)this.consolidationKey), Optional.fromNullable((Object)this.expiresAfter), this.extra == null ? Optional.absent() : Optional.fromNullable((Object)this.extra.build()), Optional.fromNullable((Object)this.interactive));
        }
    }
}

