/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.android;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.push.model.DeviceType;
import com.urbanairship.api.push.model.PushExpiry;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.DevicePayloadOverride;
import com.urbanairship.api.push.model.notification.Interactive;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AndroidDevicePayload
extends PushModelObject
implements DevicePayloadOverride {
    private final Optional<String> alert;
    private final Optional<String> collapseKey;
    private final Optional<PushExpiry> timeToLive;
    private final Optional<Boolean> delayWhileIdle;
    private final Optional<ImmutableMap<String, String>> extra;
    private final Optional<Interactive> interactive;

    private AndroidDevicePayload(Optional<String> alert, Optional<String> collapseKey, Optional<PushExpiry> timeToLive, Optional<Boolean> delayWhileIdle, Optional<ImmutableMap<String, String>> extra, Optional<Interactive> interactive) {
        this.alert = alert;
        this.collapseKey = collapseKey;
        this.timeToLive = timeToLive;
        this.delayWhileIdle = delayWhileIdle;
        this.extra = extra;
        this.interactive = interactive;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.ANDROID;
    }

    @Override
    public Optional<String> getAlert() {
        return this.alert;
    }

    public Optional<String> getCollapseKey() {
        return this.collapseKey;
    }

    public Optional<PushExpiry> getTimeToLive() {
        return this.timeToLive;
    }

    public Optional<Boolean> getDelayWhileIdle() {
        return this.delayWhileIdle;
    }

    public Optional<ImmutableMap<String, String>> getExtra() {
        return this.extra;
    }

    public Optional<Interactive> getInteractive() {
        return this.interactive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidDevicePayload that = (AndroidDevicePayload)o;
        if (this.alert != null ? !this.alert.equals(that.alert) : that.alert != null) {
            return false;
        }
        if (this.collapseKey != null ? !this.collapseKey.equals(that.collapseKey) : that.collapseKey != null) {
            return false;
        }
        if (this.timeToLive != null ? !this.timeToLive.equals(that.timeToLive) : that.timeToLive != null) {
            return false;
        }
        if (this.delayWhileIdle != null ? !this.delayWhileIdle.equals(that.delayWhileIdle) : that.delayWhileIdle != null) {
            return false;
        }
        if (this.extra != null ? !this.extra.equals(that.extra) : that.extra != null) {
            return false;
        }
        return !(this.interactive != null ? !this.interactive.equals(that.interactive) : that.interactive != null);
    }

    public int hashCode() {
        int result = this.alert != null ? this.alert.hashCode() : 0;
        result = 31 * result + (this.collapseKey != null ? this.collapseKey.hashCode() : 0);
        result = 31 * result + (this.timeToLive != null ? this.timeToLive.hashCode() : 0);
        result = 31 * result + (this.delayWhileIdle != null ? this.delayWhileIdle.hashCode() : 0);
        result = 31 * result + (this.extra != null ? this.extra.hashCode() : 0);
        result = 31 * result + (this.interactive != null ? this.interactive.hashCode() : 0);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private String alert = null;
        private String collapseKey = null;
        private PushExpiry timeToLive = null;
        private Boolean delayWhileIdle = null;
        private ImmutableMap.Builder<String, String> extra = null;
        private Interactive interactive = null;

        private Builder() {
        }

        public Builder setAlert(String alert) {
            this.alert = alert;
            return this;
        }

        public Builder setCollapseKey(String collapseKey) {
            this.collapseKey = collapseKey;
            return this;
        }

        public Builder setTimeToLive(PushExpiry value) {
            this.timeToLive = value;
            return this;
        }

        public Builder setDelayWhileIdle(boolean value) {
            this.delayWhileIdle = value;
            return this;
        }

        public Builder addExtraEntry(String key, String value) {
            if (this.extra == null) {
                this.extra = ImmutableMap.builder();
            }
            this.extra.put((Object)key, (Object)value);
            return this;
        }

        public Builder addAllExtraEntries(Map<String, String> entries) {
            if (this.extra == null) {
                this.extra = ImmutableMap.builder();
            }
            this.extra.putAll(entries);
            return this;
        }

        public Builder setInteractive(Interactive value) {
            this.interactive = value;
            return this;
        }

        public AndroidDevicePayload build() {
            return new AndroidDevicePayload(Optional.fromNullable((Object)this.alert), Optional.fromNullable((Object)this.collapseKey), Optional.fromNullable((Object)this.timeToLive), Optional.fromNullable((Object)this.delayWhileIdle), this.extra == null ? Optional.absent() : Optional.fromNullable((Object)this.extra.build()), Optional.fromNullable((Object)this.interactive));
        }
    }
}

