/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.mpns;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.notification.mpns.MPNSTileData;
import com.urbanairship.api.push.model.notification.mpns.Validation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPNSIconicTileData
extends MPNSTileData {
    private final Optional<String> iconImage;
    private final Optional<String> smallIconImage;
    private final Optional<String> backgroundColor;
    private final Optional<String> wideContent1;
    private final Optional<String> wideContent2;
    private final Optional<String> wideContent3;

    private MPNSIconicTileData(Optional<String> id, Optional<String> title, Optional<Integer> count, Optional<String> iconImage, Optional<String> smallIconImage, Optional<String> backgroundColor, Optional<String> wideContent1, Optional<String> wideContent2, Optional<String> wideContent3) {
        super(id, title, count);
        this.iconImage = iconImage;
        this.smallIconImage = smallIconImage;
        this.backgroundColor = backgroundColor;
        this.wideContent1 = wideContent1;
        this.wideContent2 = wideContent2;
        this.wideContent3 = wideContent3;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public String getTemplate() {
        return "IconicTile";
    }

    public Optional<String> getIconImage() {
        return this.iconImage;
    }

    public Optional<String> getSmallIconImage() {
        return this.smallIconImage;
    }

    public Optional<String> getBackgroundColor() {
        return this.backgroundColor;
    }

    public Optional<String> getWideContent1() {
        return this.wideContent1;
    }

    public Optional<String> getWideContent2() {
        return this.wideContent2;
    }

    public Optional<String> getWideContent3() {
        return this.wideContent3;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MPNSIconicTileData that = (MPNSIconicTileData)o;
        if (this.iconImage != null ? !this.iconImage.equals(that.iconImage) : that.iconImage != null) {
            return false;
        }
        if (this.smallIconImage != null ? !this.smallIconImage.equals(that.smallIconImage) : that.smallIconImage != null) {
            return false;
        }
        if (this.backgroundColor != null ? !this.backgroundColor.equals(that.backgroundColor) : that.backgroundColor != null) {
            return false;
        }
        if (this.wideContent1 != null ? !this.wideContent1.equals(that.wideContent1) : that.wideContent1 != null) {
            return false;
        }
        if (this.wideContent2 != null ? !this.wideContent2.equals(that.wideContent2) : that.wideContent2 != null) {
            return false;
        }
        return !(this.wideContent3 != null ? !this.wideContent3.equals(that.wideContent3) : that.wideContent3 != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.iconImage != null ? this.iconImage.hashCode() : 0);
        result = 31 * result + (this.smallIconImage != null ? this.smallIconImage.hashCode() : 0);
        result = 31 * result + (this.backgroundColor != null ? this.backgroundColor.hashCode() : 0);
        result = 31 * result + (this.wideContent1 != null ? this.wideContent1.hashCode() : 0);
        result = 31 * result + (this.wideContent2 != null ? this.wideContent2.hashCode() : 0);
        result = 31 * result + (this.wideContent3 != null ? this.wideContent3.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private String id;
        private String title;
        private Integer count;
        private String iconImage;
        private String smallIconImage;
        private String backgroundColor;
        private String wideContent1;
        private String wideContent2;
        private String wideContent3;

        private Builder() {
        }

        public Builder setId(String value) {
            this.id = value;
            return this;
        }

        public Builder setTitle(String value) {
            this.title = value;
            return this;
        }

        public Builder setCount(int value) {
            this.count = new Integer(value);
            return this;
        }

        public Builder setIconImage(String value) {
            this.iconImage = value;
            return this;
        }

        public Builder setSmallIconImage(String value) {
            this.smallIconImage = value;
            return this;
        }

        public Builder setBackgroundColor(String value) {
            this.backgroundColor = value;
            return this;
        }

        public Builder setWideContent1(String value) {
            this.wideContent1 = value;
            return this;
        }

        public Builder setWideContent2(String value) {
            this.wideContent2 = value;
            return this;
        }

        public Builder setWideContent3(String value) {
            this.wideContent3 = value;
            return this;
        }

        public MPNSIconicTileData build() {
            Preconditions.checkArgument((this.title != null || this.iconImage != null || this.smallIconImage != null || this.backgroundColor != null || this.wideContent1 != null || this.wideContent2 != null || this.wideContent3 != null ? 1 : 0) != 0, (Object)"tile must not be empty");
            Validation.validatePath(this.id, "id");
            Validation.validateStringValue(this.title, "title");
            Validation.validateUriValue(this.iconImage, "icon_image");
            Validation.validateUriValue(this.smallIconImage, "small_icon_image");
            Validation.validateColorValue(this.backgroundColor, "background_color");
            Validation.validateStringValue(this.wideContent1, "wide_content_1");
            Validation.validateStringValue(this.wideContent2, "wide_content_2");
            Validation.validateStringValue(this.wideContent3, "wide_content_3");
            return new MPNSIconicTileData(Optional.fromNullable((Object)this.id), Optional.fromNullable((Object)this.title), Optional.fromNullable((Object)this.count), Optional.fromNullable((Object)this.iconImage), Optional.fromNullable((Object)this.smallIconImage), Optional.fromNullable((Object)this.backgroundColor), Optional.fromNullable((Object)this.wideContent1), Optional.fromNullable((Object)this.wideContent2), Optional.fromNullable((Object)this.wideContent3));
        }
    }
}

