/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.mpns;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.notification.mpns.MPNSTileData;
import com.urbanairship.api.push.model.notification.mpns.MPNSToastData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPNSPush {
    private final Type type;
    private final BatchingInterval interval;
    private final Optional<MPNSTileData> tile;
    private final Optional<MPNSToastData> toast;

    private MPNSPush(Type type, BatchingInterval interval, Optional<MPNSTileData> tile, Optional<MPNSToastData> toast) {
        this.type = type;
        this.interval = interval;
        this.tile = tile;
        this.toast = toast;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Type getType() {
        return this.type;
    }

    public BatchingInterval getBatchingInterval() {
        return this.interval;
    }

    public Optional<MPNSTileData> getTile() {
        return this.tile;
    }

    public Optional<MPNSToastData> getToast() {
        return this.toast;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MPNSPush that = (MPNSPush)o;
        if (this.type != null ? !this.type.equals((Object)that.type) : that.type != null) {
            return false;
        }
        if (this.interval != null ? !this.interval.equals((Object)that.interval) : that.interval != null) {
            return false;
        }
        if (this.tile != null ? !this.tile.equals(that.tile) : that.tile != null) {
            return false;
        }
        return !(this.toast != null ? !this.toast.equals(that.toast) : that.toast != null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
        result = 31 * result + (this.tile != null ? this.tile.hashCode() : 0);
        result = 31 * result + (this.toast != null ? this.toast.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private Type type;
        private BatchingInterval interval = BatchingInterval.IMMEDIATE;
        private MPNSTileData tile;
        private MPNSToastData toast;

        private Builder() {
        }

        public Builder setType(Type value) {
            this.type = value;
            return this;
        }

        public Builder setBatchingInterval(BatchingInterval value) {
            if (value != null) {
                this.interval = value;
            }
            return this;
        }

        public Builder setTile(MPNSTileData value) {
            this.tile = value;
            return this;
        }

        public Builder setToast(MPNSToastData value) {
            this.toast = value;
            return this;
        }

        public MPNSPush build() {
            Preconditions.checkArgument((this.type != null && (this.type == Type.TOAST || this.type == Type.TILE) ? 1 : 0) != 0, (Object)"type must be one of 'toast' or 'tile'");
            if (this.type == Type.TILE) {
                Preconditions.checkArgument((this.tile != null ? 1 : 0) != 0, (Object)"tile data was missing");
            } else if (this.type == Type.TOAST) {
                Preconditions.checkArgument((this.toast != null ? 1 : 0) != 0, (Object)"toast data was missing");
            }
            return new MPNSPush(this.type, this.interval, Optional.fromNullable((Object)this.tile), Optional.fromNullable((Object)this.toast));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BatchingInterval {
        IMMEDIATE,
        SHORT,
        LONG;


        public static BatchingInterval get(String value) {
            for (BatchingInterval interval : BatchingInterval.values()) {
                if (!value.equalsIgnoreCase(interval.name())) continue;
                return interval;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        TOAST,
        TILE;


        public static Type get(String value) {
            for (Type type : Type.values()) {
                if (!value.equalsIgnoreCase(type.name())) continue;
                return type;
            }
            return null;
        }
    }
}

