/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.mpns;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.notification.mpns.Validation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPNSToastData {
    private final Optional<String> text1;
    private final Optional<String> text2;
    private final Optional<String> param;

    private MPNSToastData(Optional<String> text1, Optional<String> text2, Optional<String> param) {
        this.text1 = text1;
        this.text2 = text2;
        this.param = param;
    }

    public Optional<String> getText1() {
        return this.text1;
    }

    public Optional<String> getText2() {
        return this.text2;
    }

    public Optional<String> getParam() {
        return this.param;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MPNSToastData that = (MPNSToastData)o;
        if (this.text1 != null ? !this.text1.equals(that.text1) : that.text1 != null) {
            return false;
        }
        if (this.text2 != null ? !this.text2.equals(that.text2) : that.text2 != null) {
            return false;
        }
        return !(this.param != null ? !this.param.equals(that.param) : that.param != null);
    }

    public int hashCode() {
        int result = this.text1 != null ? this.text1.hashCode() : 0;
        result = 31 * result + (this.text2 != null ? this.text2.hashCode() : 0);
        result = 31 * result + (this.param != null ? this.param.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private String text1;
        private String text2;
        private String param;

        private Builder() {
        }

        public Builder setText1(String value) {
            this.text1 = value;
            return this;
        }

        public Builder setText2(String value) {
            this.text2 = value;
            return this;
        }

        public Builder setParam(String value) {
            this.param = value;
            return this;
        }

        public MPNSToastData build() {
            Preconditions.checkArgument((this.text1 != null || this.text2 != null ? 1 : 0) != 0, (Object)"At least one of text1 or text2 must be set");
            Validation.validateStringValue(this.text1, "text1");
            Validation.validateStringValue(this.text2, "text2");
            Validation.validatePath(this.param, "param");
            return new MPNSToastData(Optional.fromNullable((Object)this.text1), Optional.fromNullable((Object)this.text2), Optional.fromNullable((Object)this.param));
        }
    }
}

