/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.wns;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WNSAudioData {
    private final Sound sound;
    private final Optional<Boolean> loop;

    private WNSAudioData(Sound sound, Optional<Boolean> loop) {
        this.sound = sound;
        this.loop = loop;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Sound getSound() {
        return this.sound;
    }

    public Optional<Boolean> getLoop() {
        return this.loop;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WNSAudioData that = (WNSAudioData)o;
        if (this.sound != null ? !this.sound.equals((Object)that.sound) : that.sound != null) {
            return false;
        }
        return !(this.loop != null ? !this.loop.equals(that.loop) : that.loop != null);
    }

    public int hashCode() {
        int result = this.sound != null ? this.sound.hashCode() : 0;
        result = 31 * result + (this.loop != null ? this.loop.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private Sound sound;
        private Boolean loop;

        private Builder() {
        }

        public Builder setSound(Sound value) {
            this.sound = value;
            return this;
        }

        public Builder setLoop(Boolean value) {
            this.loop = value;
            return this;
        }

        public WNSAudioData build() {
            Preconditions.checkArgument((this.sound != null ? 1 : 0) != 0, (Object)"toast.audio must supply a value for 'sound'");
            return new WNSAudioData(this.sound, Optional.fromNullable((Object)this.loop));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sound {
        MUTE,
        DEFAULT,
        IM,
        MAIL,
        REMINDER,
        SMS,
        LOOPING_ALARM,
        LOOPING_ALARM2,
        LOOPING_CALL,
        LOOPING_CALL2;

        private final String id = this.name().toLowerCase().replace('_', '-');

        public String getIdentifier() {
            return this.id;
        }

        public static Sound get(String value) {
            for (Sound sound : Sound.values()) {
                if (!value.equalsIgnoreCase(sound.getIdentifier())) continue;
                return sound;
            }
            return null;
        }
    }
}

