/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse;

import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.push.model.DeviceType;
import com.urbanairship.api.push.model.DeviceTypeData;
import java.io.IOException;
import java.util.Set;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformDataDeserializer
extends JsonDeserializer<DeviceTypeData> {
    public static final PlatformDataDeserializer INSTANCE = new PlatformDataDeserializer();

    public DeviceTypeData deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        DeviceTypeData.Builder builder = DeviceTypeData.newBuilder();
        JsonToken token = parser.getCurrentToken();
        if (token == JsonToken.VALUE_STRING) {
            String value = parser.getText();
            if (!"all".equals(value)) {
                APIParsingException.raise(String.format("Invalid value \"%s\" for \"device_types\". Must be \"all\" or an array of platform identifiers.", value), parser);
            } else {
                builder.setAll(true);
            }
        } else {
            Set deviceTypes = (Set)parser.readValueAs((TypeReference)new TypeReference<Set<DeviceType>>(){});
            builder.addAllDeviceTypes(deviceTypes);
        }
        return builder.build();
    }
}

