/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse;

import com.google.common.base.Optional;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.push.model.DeviceType;
import java.io.IOException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformDeserializer
extends JsonDeserializer<DeviceType> {
    public DeviceType deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String deviceTypeString = jp.getText();
        Optional platform = (Optional)DeviceType.fromIdentifierFunction.apply((Object)deviceTypeString);
        if (!platform.isPresent()) {
            APIParsingException.raise(String.format("Unrecognized device type '%s'", deviceTypeString), jp);
        }
        return (DeviceType)((Object)platform.get());
    }
}

