/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse.audience;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.FieldParser;
import com.urbanairship.api.common.parse.FieldParserRegistry;
import com.urbanairship.api.common.parse.MapFieldParserRegistry;
import com.urbanairship.api.common.parse.StandardObjectDeserializer;
import com.urbanairship.api.push.model.audience.Selector;
import com.urbanairship.api.push.model.audience.SelectorType;
import com.urbanairship.api.push.model.audience.Selectors;
import com.urbanairship.api.push.parse.audience.SelectorReader;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorDeserializer
extends JsonDeserializer<Selector> {
    private static final FieldParserRegistry<Selector, SelectorReader> FIELD_PARSERS = new MapFieldParserRegistry<Selector, SelectorReader>((Map<String, FieldParser<SelectorReader>>)new CaseInsensitiveMap((Map)ImmutableMap.builder().put((Object)"tag", (Object)new FieldParser<SelectorReader>(){

        @Override
        public void parse(SelectorReader reader, JsonParser parser, DeserializationContext context) throws IOException {
            reader.readValueSelector(SelectorType.TAG, parser, context);
        }
    }).put((Object)"alias", (Object)new FieldParser<SelectorReader>(){

        @Override
        public void parse(SelectorReader reader, JsonParser parser, DeserializationContext context) throws IOException {
            reader.readValueSelector(SelectorType.ALIAS, parser, context);
        }
    }).put((Object)"segment", (Object)new FieldParser<SelectorReader>(){

        @Override
        public void parse(SelectorReader reader, JsonParser parser, DeserializationContext context) throws IOException {
            reader.readValueSelector(SelectorType.SEGMENT, parser, context);
        }
    }).put((Object)"device_token", (Object)new FieldParser<SelectorReader>(){

        @Override
        public void parse(SelectorReader reader, JsonParser parser, DeserializationContext context) throws IOException {
            reader.readValueSelector(SelectorType.DEVICE_TOKEN, parser, context);
        }
    }).put((Object)"device_pin", (Object)new FieldParser<SelectorReader>(){

        @Override
        public void parse(SelectorReader reader, JsonParser parser, DeserializationContext context) throws IOException {
            reader.readValueSelector(SelectorType.DEVICE_PIN, parser, context);
        }
    }).put((Object)"apid", (Object)new FieldParser<SelectorReader>(){

        @Override
        public void parse(SelectorReader reader, JsonParser parser, DeserializationContext context) throws IOException {
            reader.readValueSelector(SelectorType.APID, parser, context);
        }
    }).put((Object)"wns", (Object)new FieldParser<SelectorReader>(){

        @Override
        public void parse(SelectorReader reader, JsonParser parser, DeserializationContext context) throws IOException {
            reader.readValueSelector(SelectorType.WNS, parser, context);
        }
    }).put((Object)"mpns", (Object)new FieldParser<SelectorReader>(){

        @Override
        public void parse(SelectorReader reader, JsonParser parser, DeserializationContext context) throws IOException {
            reader.readValueSelector(SelectorType.MPNS, parser, context);
        }
    }).put((Object)"ios_channel", (Object)new FieldParser<SelectorReader>(){

        @Override
        public void parse(SelectorReader reader, JsonParser parser, DeserializationContext context) throws IOException {
            reader.readValueSelector(SelectorType.IOS_CHANNEL, parser, context);
        }
    }).put((Object)"amazon_channel", (Object)new FieldParser<SelectorReader>(){

        @Override
        public void parse(SelectorReader reader, JsonParser parser, DeserializationContext context) throws IOException {
            reader.readValueSelector(SelectorType.AMAZON_CHANNEL, parser, context);
        }
    }).put((Object)"android_channel", (Object)new FieldParser<SelectorReader>(){

        @Override
        public void parse(SelectorReader reader, JsonParser parser, DeserializationContext context) throws IOException {
            reader.readValueSelector(SelectorType.ANDROID_CHANNEL, parser, context);
        }
    }).put((Object)"and", (Object)new FieldParser<SelectorReader>(){

        @Override
        public void parse(SelectorReader reader, JsonParser parser, DeserializationContext context) throws IOException {
            reader.readCompoundSelector(SelectorType.AND, parser, context);
        }
    }).put((Object)"or", (Object)new FieldParser<SelectorReader>(){

        @Override
        public void parse(SelectorReader reader, JsonParser parser, DeserializationContext context) throws IOException {
            reader.readCompoundSelector(SelectorType.OR, parser, context);
        }
    }).put((Object)"not", (Object)new FieldParser<SelectorReader>(){

        @Override
        public void parse(SelectorReader reader, JsonParser parser, DeserializationContext context) throws IOException {
            reader.readCompoundSelector(SelectorType.NOT, parser, context);
        }
    }).put((Object)"location", (Object)new FieldParser<SelectorReader>(){

        @Override
        public void parse(SelectorReader reader, JsonParser parser, DeserializationContext context) throws IOException {
            reader.readLocationSelector(parser, context);
        }
    }).build()), new FieldParser<SelectorReader>(){

        @Override
        public void parse(SelectorReader reader, JsonParser parser, DeserializationContext context) throws IOException {
            reader.readExtraField(parser, context);
        }
    });
    public static final SelectorDeserializer INSTANCE = new SelectorDeserializer();
    private final StandardObjectDeserializer<Selector, ?> deserializer = new StandardObjectDeserializer<Selector, SelectorReader>(FIELD_PARSERS, new Supplier<SelectorReader>(){

        public SelectorReader get() {
            return new SelectorReader();
        }
    });

    public Selector deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonToken token = parser.getCurrentToken();
        if (token == JsonToken.VALUE_STRING) {
            return this.readAtomicSelector(parser, context);
        }
        return this.deserializer.deserialize(parser, context);
    }

    private Selector readAtomicSelector(JsonParser parser, DeserializationContext context) throws IOException {
        String value = parser.getText();
        SelectorType type = SelectorType.getSelectorTypeFromIdentifier(value);
        if (type != null) {
            return Selectors.atomic(type);
        }
        throw new APIParsingException(String.format("Unknown atomic selector '%s'", value));
    }
}

