/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse.audience;

import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.push.model.audience.BasicCompoundSelector;
import com.urbanairship.api.push.model.audience.BasicSelector;
import com.urbanairship.api.push.model.audience.BasicValueSelector;
import com.urbanairship.api.push.model.audience.Selector;
import com.urbanairship.api.push.model.audience.SelectorCategory;
import com.urbanairship.api.push.model.audience.SelectorType;
import com.urbanairship.api.push.model.audience.Selectors;
import com.urbanairship.api.push.model.audience.location.LocationSelector;
import com.urbanairship.api.push.parse.audience.SelectorDeserializer;
import com.urbanairship.api.push.parse.audience.Validation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorReader
implements JsonObjectReader<Selector> {
    private BasicSelector.Builder basic = null;
    private BasicValueSelector.Builder value = null;
    private BasicCompoundSelector.Builder compound = null;
    private ImmutableMap.Builder<String, String> extra = null;
    private LocationSelector location = null;

    public void readValueSelector(SelectorType type, JsonParser parser, DeserializationContext context) throws IOException {
        JsonToken token;
        if (this.value != null || this.compound != null) {
            APIParsingException.raise(String.format("Specified more than one type of selector ('%s' was unexpected)", type.getIdentifier()), parser);
        }
        if ((token = parser.getCurrentToken()) == JsonToken.VALUE_STRING) {
            this.value = BasicValueSelector.newBuilder().setType(type).setValue(parser.getText());
        } else if (token == JsonToken.START_ARRAY) {
            this.compound = BasicCompoundSelector.newBuilder().setType(SelectorType.OR);
            List<String> values = this.readListOfStrings(parser, context);
            for (String value : values) {
                Selector child = Selectors.value(type, value);
                Validation.validate(child);
                this.compound.addSelector(child);
            }
        }
    }

    public void readCompoundSelector(SelectorType type, JsonParser parser, DeserializationContext context) throws IOException {
        if (this.value != null || this.compound != null) {
            APIParsingException.raise(String.format("Specified more than one type of selector ('%s' was unexpected'", type.getIdentifier()), parser);
        }
        this.compound = BasicCompoundSelector.newBuilder().setType(type);
        List<Selector> children = this.readListOfSelectors(parser, context);
        for (Selector child : children) {
            Validation.validate(child);
        }
        this.compound.addAllSelectors(children);
    }

    public void readLocationSelector(JsonParser parser, DeserializationContext context) throws IOException {
        this.location = (LocationSelector)parser.readValueAs(LocationSelector.class);
    }

    public void readExtraField(JsonParser parser, DeserializationContext context) throws IOException {
        if (this.extra == null) {
            this.extra = ImmutableMap.builder();
        }
        this.extra.put((Object)parser.getCurrentName(), (Object)parser.getText());
    }

    public List<Selector> readListOfSelectors(JsonParser parser, DeserializationContext context) throws IOException {
        ArrayList<Selector> selectors = new ArrayList<Selector>();
        JsonToken token = parser.getCurrentToken();
        if (token == JsonToken.START_ARRAY) {
            token = parser.nextToken();
            while (token != JsonToken.END_ARRAY) {
                selectors.add(this.readSelectorInList(parser, context));
                token = parser.nextToken();
            }
        } else if (token == JsonToken.START_OBJECT) {
            selectors.add(this.readSelectorInList(parser, context));
        }
        return selectors;
    }

    private Selector readSelectorInList(JsonParser parser, DeserializationContext context) throws IOException {
        Selector selector = SelectorDeserializer.INSTANCE.deserialize(parser, context);
        if (selector.getType().getCategory() == SelectorCategory.ATOMIC) {
            APIParsingException.raise(String.format("Atomic selector '%s' cannot appear in a compound selector.", selector.getType().getIdentifier()), parser);
        }
        Validation.validate(selector);
        return selector;
    }

    public List<String> readListOfStrings(JsonParser parser, DeserializationContext context) throws IOException {
        ArrayList<String> strings = new ArrayList<String>();
        JsonToken token = parser.getCurrentToken();
        if (token == JsonToken.START_ARRAY) {
            token = parser.nextToken();
        }
        while (token != JsonToken.END_ARRAY) {
            if (token != JsonToken.VALUE_STRING) {
                APIParsingException.raise(String.format("Expected a string, but got '%s'", token), parser);
            }
            strings.add(parser.getText());
            token = parser.nextToken();
        }
        return strings;
    }

    @Override
    public Selector validateAndBuild() throws IOException {
        try {
            if (this.basic != null) {
                return Validation.validate(this.basic.build());
            }
            if (this.value != null) {
                if (this.extra != null) {
                    this.value.addAllAttributes((Map<String, String>)this.extra.build());
                }
                return Validation.validate(this.value.build());
            }
            if (this.compound != null) {
                return Validation.validate(this.compound.build());
            }
            if (this.location != null) {
                return this.location;
            }
            throw new APIParsingException("Empty selector.");
        }
        catch (APIParsingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage(), (Throwable)e);
        }
    }
}

