/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse.audience.location;

import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.DateFormats;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.push.model.audience.location.AbsoluteDateRange;
import java.io.IOException;
import org.codehaus.jackson.JsonParser;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbsoluteDateRangeReader
implements JsonObjectReader<AbsoluteDateRange.Builder> {
    private AbsoluteDateRange.Builder builder = AbsoluteDateRange.newBuilder();
    private static final DateTimeFormatter[] FORMATS = new DateTimeFormatter[]{DateFormats.DATE_PARSER, DateFormats.SECONDS_FORMAT, DateFormats.MINUTES_FORMAT, DateFormats.HOURS_FORMAT, DateFormats.DAYS_FORMAT, DateFormats.WEEKS_FORMAT, DateFormats.MONTHS_FORMAT, DateFormats.YEARS_FORMAT};

    AbsoluteDateRangeReader() {
    }

    public void readStart(JsonParser parser) throws IOException {
        this.builder.setStart(this.readDateTime(parser));
    }

    public void readEnd(JsonParser parser) throws IOException {
        this.builder.setEnd(this.readDateTime(parser));
    }

    private DateTime readDateTime(JsonParser parser) throws IOException {
        String dateString = parser.getText();
        DateTime value = null;
        for (DateTimeFormatter format : FORMATS) {
            try {
                value = format.parseDateTime(dateString);
                if (value == null) continue;
                return value;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        throw new APIParsingException(String.format("Time period specifier '%s' is not a valid date time.", dateString));
    }

    @Override
    public AbsoluteDateRange.Builder validateAndBuild() throws IOException {
        return this.builder;
    }
}

