/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse.audience.location;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.common.parse.FieldParser;
import com.urbanairship.api.common.parse.FieldParserRegistry;
import com.urbanairship.api.common.parse.MapFieldParserRegistry;
import com.urbanairship.api.common.parse.StandardObjectDeserializer;
import com.urbanairship.api.push.model.audience.location.DateRange;
import com.urbanairship.api.push.model.audience.location.DateRangeUnit;
import com.urbanairship.api.push.parse.audience.location.DateRangeReader;
import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateRangeDeserializer
extends JsonDeserializer<DateRange> {
    private static final FieldParserRegistry<DateRange, DateRangeReader> FIELD_PARSERS = new MapFieldParserRegistry<DateRange, DateRangeReader>((Map<String, FieldParser<DateRangeReader>>)ImmutableMap.builder().put((Object)"recent", (Object)new FieldParser<DateRangeReader>(){

        @Override
        public void parse(DateRangeReader reader, JsonParser parser, DeserializationContext context) throws IOException {
            reader.readRecent(parser);
        }
    }).put((Object)"last_seen", (Object)new FieldParser<DateRangeReader>(){

        @Override
        public void parse(DateRangeReader reader, JsonParser parser, DeserializationContext context) throws IOException {
            reader.readTimeframe(parser);
        }
    }).build(), new FieldParser<DateRangeReader>(){

        @Override
        public void parse(DateRangeReader reader, JsonParser parser, DeserializationContext context) throws IOException {
            String field = parser.getCurrentName();
            DateRangeUnit resolution = DateRangeUnit.getUnitForIdentifier(field);
            if (resolution != null) {
                reader.readAbsolute(parser);
                reader.setResolution(resolution);
            }
        }
    });
    private final StandardObjectDeserializer<DateRange, ?> deserializer = new StandardObjectDeserializer<DateRange, DateRangeReader>(FIELD_PARSERS, new Supplier<DateRangeReader>(){

        public DateRangeReader get() {
            return new DateRangeReader();
        }
    });

    public DateRange deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        return this.deserializer.deserialize(parser, deserializationContext);
    }
}

