/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse.audience.location;

import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.push.model.audience.location.DateRange;
import com.urbanairship.api.push.model.audience.location.LocationAlias;
import com.urbanairship.api.push.model.audience.location.LocationIdentifier;
import com.urbanairship.api.push.model.audience.location.LocationSelector;
import java.io.IOException;
import org.codehaus.jackson.JsonParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationSelectorReader
implements JsonObjectReader<LocationSelector> {
    private final LocationSelector.Builder builder = LocationSelector.newBuilder();

    public void readId(JsonParser parser) throws IOException {
        this.builder.setId(LocationIdentifier.newBuilder().setId(parser.getText()).build());
    }

    public void readDateRange(JsonParser parser) throws IOException {
        this.builder.setDateRange((DateRange)parser.readValueAs(DateRange.class));
    }

    public void readAlias(JsonParser parser) throws IOException {
        String aliasType = parser.getCurrentName();
        String aliasValue = parser.getText();
        this.builder.setId(LocationIdentifier.newBuilder().setAlias(LocationAlias.newBuilder().setType(aliasType).setValue(aliasValue).build()).build());
    }

    @Override
    public LocationSelector validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage(), (Throwable)e);
        }
    }
}

