/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse.notification;

import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.push.model.notification.Interactive;
import com.urbanairship.api.push.model.notification.actions.Actions;
import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractiveReader
implements JsonObjectReader<Interactive> {
    private final Interactive.Builder builder = Interactive.newBuilder();

    public void readType(JsonParser parser) throws IOException {
        this.builder.setType((String)parser.readValueAs(String.class));
    }

    public void readButtonActions(JsonParser parser) throws IOException {
        Map actionsMap = (Map)parser.readValueAs((TypeReference)new TypeReference<Map<String, Actions>>(){});
        ImmutableMap actionsImmutableMap = actionsMap == null ? null : ImmutableMap.copyOf((Map)actionsMap);
        this.builder.setButtonActions((ImmutableMap<String, Actions>)actionsImmutableMap);
    }

    @Override
    public Interactive validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage());
        }
    }
}

