/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse.notification;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.common.parse.StringFieldDeserializer;
import com.urbanairship.api.push.model.DeviceType;
import com.urbanairship.api.push.model.notification.DevicePayloadOverride;
import com.urbanairship.api.push.model.notification.Interactive;
import com.urbanairship.api.push.model.notification.Notification;
import com.urbanairship.api.push.model.notification.actions.Actions;
import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationReader
implements JsonObjectReader<Notification> {
    private final Map<DeviceType, JsonDeserializer<? extends DevicePayloadOverride>> payloadOverridesDeserializerRegistry;
    private final Map<DeviceType, DevicePayloadOverride> payloadOverrides = Maps.newHashMap();
    private String alert = null;
    private Optional<Actions> optActions = Optional.absent();
    private Optional<Interactive> interactive = Optional.absent();

    public NotificationReader(Map<DeviceType, JsonDeserializer<? extends DevicePayloadOverride>> payloadOverridesDeserializerRegistry) {
        this.payloadOverridesDeserializerRegistry = payloadOverridesDeserializerRegistry;
    }

    public void readAlert(JsonParser parser) throws IOException {
        this.alert = StringFieldDeserializer.INSTANCE.deserialize(parser, "alert");
    }

    public void readPlatformDevicePayloadOverride(DeviceType deviceType, JsonParser parser, DeserializationContext context) throws IOException {
        JsonDeserializer<? extends DevicePayloadOverride> deserializer = this.payloadOverridesDeserializerRegistry.get((Object)deviceType);
        if (deserializer == null) {
            APIParsingException.raise("Unsupported platform " + deviceType.getIdentifier(), parser);
        }
        this.payloadOverrides.put(deviceType, (DevicePayloadOverride)deserializer.deserialize(parser, context));
    }

    public void readActions(JsonParser parser) throws IOException {
        this.optActions = Optional.of((Object)parser.readValueAs(Actions.class));
    }

    public void readInteractive(JsonParser parser) throws IOException {
        this.interactive = Optional.of((Object)parser.readValueAs(Interactive.class));
    }

    @Override
    public Notification validateAndBuild() throws IOException {
        if (this.alert == null && this.payloadOverrides.isEmpty()) {
            throw new APIParsingException("\"notification\" element must contain at least a default alert or a platform override element");
        }
        Notification.Builder builder = Notification.newBuilder();
        if (this.alert != null) {
            builder.setAlert(this.alert);
        }
        for (Map.Entry<DeviceType, DevicePayloadOverride> overrideEntry : this.payloadOverrides.entrySet()) {
            builder.addDeviceTypeOverride(overrideEntry.getKey(), overrideEntry.getValue());
        }
        if (this.optActions.isPresent()) {
            builder.setActions((Actions)this.optActions.get());
        }
        if (this.interactive.isPresent()) {
            builder.setInteractive((Interactive)this.interactive.get());
        }
        try {
            return builder.build();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

