/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse.notification.ios;

import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.BooleanFieldDeserializer;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.common.parse.MapOfStringsDeserializer;
import com.urbanairship.api.common.parse.StringFieldDeserializer;
import com.urbanairship.api.push.model.PushExpiry;
import com.urbanairship.api.push.model.notification.Interactive;
import com.urbanairship.api.push.model.notification.ios.IOSDevicePayload;
import com.urbanairship.api.push.parse.notification.ios.IOSAlertDataDeserializer;
import com.urbanairship.api.push.parse.notification.ios.IOSBadgeDataDeserializer;
import java.io.IOException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOSDevicePayloadReader
implements JsonObjectReader<IOSDevicePayload> {
    private IOSDevicePayload.Builder builder = IOSDevicePayload.newBuilder();
    private IOSAlertDataDeserializer alertDS = new IOSAlertDataDeserializer();

    public void readAlert(JsonParser parser, DeserializationContext context) throws IOException {
        this.builder.setAlert(this.alertDS.deserialize(parser, context));
    }

    public void readSound(JsonParser parser, DeserializationContext context) throws IOException {
        this.builder.setSound(StringFieldDeserializer.INSTANCE.deserialize(parser, "sound"));
    }

    public void readBadge(JsonParser parser, DeserializationContext context) throws IOException {
        this.builder.setBadge(IOSBadgeDataDeserializer.INSTANCE.deserialize(parser, "badge"));
    }

    public void readContentAvailable(JsonParser parser, DeserializationContext context) throws IOException {
        this.builder.setContentAvailable(BooleanFieldDeserializer.INSTANCE.deserialize(parser, "content_available"));
    }

    public void readExtra(JsonParser parser, DeserializationContext context) throws IOException {
        this.builder.addAllExtraEntries(MapOfStringsDeserializer.INSTANCE.deserialize(parser, "extra"));
    }

    public void readCategory(JsonParser parser, DeserializationContext context) throws IOException {
        this.builder.setCategory(StringFieldDeserializer.INSTANCE.deserialize(parser, "category"));
    }

    public void readInteractive(JsonParser parser, DeserializationContext context) throws IOException {
        this.builder.setInteractive((Interactive)parser.readValueAs(Interactive.class));
    }

    public void readExpiry(JsonParser parser, DeserializationContext context) throws IOException {
        this.builder.setExpiry((PushExpiry)parser.readValueAs(PushExpiry.class));
    }

    public void readPriority(JsonParser parser, DeserializationContext context) throws IOException {
        this.builder.setPriority(parser.getIntValue());
    }

    @Override
    public IOSDevicePayload validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage(), (Throwable)e);
        }
    }
}

