/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.joda.time.DateTime;

public final class Opens {
    private final Long android;
    private final Long ios;
    private final DateTime date;

    private Opens(Long android, Long ios, DateTime date) {
        this.android = android;
        this.ios = ios;
        this.date = date;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public long getAndroid() {
        return this.android;
    }

    public long getIos() {
        return this.ios;
    }

    public DateTime getDate() {
        return this.date;
    }

    public String toString() {
        return "Opens{android=" + this.android + ", ios=" + this.ios + ", date=" + this.date + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.android, this.ios, this.date});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Opens other = (Opens)obj;
        return Objects.equal((Object)this.android, (Object)other.android) && Objects.equal((Object)this.ios, (Object)other.ios) && Objects.equal((Object)this.date, (Object)other.date);
    }

    public static class Builder {
        private Long android;
        private Long ios;
        private DateTime date;

        private Builder() {
        }

        public Builder setAndroid(Long value) {
            this.android = value;
            return this;
        }

        public Builder setIOS(Long value) {
            this.ios = value;
            return this;
        }

        public Builder setDate(DateTime value) {
            this.date = value;
            return this;
        }

        public Opens build() {
            Preconditions.checkNotNull((Object)this.android);
            Preconditions.checkNotNull((Object)this.ios);
            Preconditions.checkNotNull((Object)this.date);
            return new Opens(this.android, this.ios, this.date);
        }
    }
}

