/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.reports.Base64ByteArray;
import com.urbanairship.api.reports.model.PerPushCounts;
import com.urbanairship.api.reports.model.PlatformType;
import java.util.UUID;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PerPushDetailResponse {
    private final String appKey;
    private final UUID pushID;
    private final Optional<DateTime> created;
    private final Optional<Base64ByteArray> pushBody;
    private final long richDeletions;
    private final long richResponses;
    private final long richSends;
    private final long sends;
    private final long directResponses;
    private final long influencedResponses;
    private final ImmutableMap<PlatformType, PerPushCounts> platforms;

    private PerPushDetailResponse(String appKey, UUID pushID, Optional<DateTime> created, Optional<Base64ByteArray> pushBody, long richDeletions, long richResponses, long richSends, long sends, long directResponses, long influencedResponses, ImmutableMap<PlatformType, PerPushCounts> platforms) {
        this.appKey = appKey;
        this.pushID = pushID;
        this.created = created;
        this.pushBody = pushBody;
        this.richDeletions = richDeletions;
        this.richResponses = richResponses;
        this.richSends = richSends;
        this.sends = sends;
        this.directResponses = directResponses;
        this.influencedResponses = influencedResponses;
        this.platforms = platforms;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getAppKey() {
        return this.appKey;
    }

    public UUID getPushID() {
        return this.pushID;
    }

    public Optional<DateTime> getCreated() {
        return this.created;
    }

    public Optional<Base64ByteArray> getPushBody() {
        return this.pushBody;
    }

    public long getRichDeletions() {
        return this.richDeletions;
    }

    public long getRichResponses() {
        return this.richResponses;
    }

    public long getRichSends() {
        return this.richSends;
    }

    public long getSends() {
        return this.sends;
    }

    public long getDirectResponses() {
        return this.directResponses;
    }

    public long getInfluencedResponses() {
        return this.influencedResponses;
    }

    public ImmutableMap<PlatformType, PerPushCounts> getPlatforms() {
        return this.platforms;
    }

    public String toString() {
        return "PerPushDetailResponse{appKey='" + this.appKey + '\'' + ", pushID=" + this.pushID + ", created=" + this.created + ", pushBody=" + this.pushBody + ", richDeletions=" + this.richDeletions + ", richResponses=" + this.richResponses + ", richSends=" + this.richSends + ", sends=" + this.sends + ", directResponses=" + this.directResponses + ", influencedResponses=" + this.influencedResponses + ", platforms=" + this.platforms + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.appKey, this.pushID, this.created, this.pushBody, this.richDeletions, this.richResponses, this.richSends, this.sends, this.directResponses, this.influencedResponses, this.platforms});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PerPushDetailResponse other = (PerPushDetailResponse)obj;
        return Objects.equal((Object)this.appKey, (Object)other.appKey) && Objects.equal((Object)this.pushID, (Object)other.pushID) && Objects.equal(this.created, other.created) && Objects.equal(this.pushBody, other.pushBody) && Objects.equal((Object)this.richDeletions, (Object)other.richDeletions) && Objects.equal((Object)this.richResponses, (Object)other.richResponses) && Objects.equal((Object)this.richSends, (Object)other.richSends) && Objects.equal((Object)this.sends, (Object)other.sends) && Objects.equal((Object)this.directResponses, (Object)other.directResponses) && Objects.equal((Object)this.influencedResponses, (Object)other.influencedResponses) && Objects.equal(this.platforms, other.platforms);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private String appKey;
        private UUID pushID;
        private Optional<DateTime> created;
        private Optional<Base64ByteArray> pushBody;
        private long richDeletions;
        private long richResponses;
        private long richSends;
        private long sends;
        private long directResponses;
        private long influencedResponses;
        private ImmutableMap.Builder<PlatformType, PerPushCounts> platforms = ImmutableMap.builder();

        private Builder() {
        }

        public Builder setAppKey(String value) {
            this.appKey = value;
            return this;
        }

        public Builder setPushID(UUID value) {
            this.pushID = value;
            return this;
        }

        public Builder setCreated(Optional<DateTime> value) {
            this.created = value;
            return this;
        }

        public Builder setPushBody(Optional<Base64ByteArray> value) {
            this.pushBody = value;
            return this;
        }

        public Builder setRichDeletions(long value) {
            this.richDeletions = value;
            return this;
        }

        public Builder setRichResponses(long value) {
            this.richResponses = value;
            return this;
        }

        public Builder setRichSends(long value) {
            this.richSends = value;
            return this;
        }

        public Builder setSends(long value) {
            this.sends = value;
            return this;
        }

        public Builder setDirectResponses(long value) {
            this.directResponses = value;
            return this;
        }

        public Builder setInfluencedResponses(long value) {
            this.influencedResponses = value;
            return this;
        }

        public Builder addPlatform(PlatformType type, PerPushCounts counts) {
            this.platforms.put((Object)type, (Object)counts);
            return this;
        }

        public Builder addAllPlatforms(ImmutableMap<PlatformType, PerPushCounts> value) {
            this.platforms.putAll(value);
            return this;
        }

        public PerPushDetailResponse build() {
            return new PerPushDetailResponse(this.appKey, this.pushID, this.created, this.pushBody, this.richDeletions, this.richResponses, this.richSends, this.sends, this.directResponses, this.influencedResponses, this.platforms.build());
        }
    }
}

