/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.reports.model.PerPushCounts;
import com.urbanairship.api.reports.model.PlatformType;
import com.urbanairship.api.reports.model.RichPerPushCounts;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlatformCounts {
    private final ImmutableMap<PlatformType, PerPushCounts> pushPlatforms;
    private final ImmutableMap<PlatformType, RichPerPushCounts> richPushPlatforms;
    private final DateTime time;

    private PlatformCounts(ImmutableMap<PlatformType, PerPushCounts> pushPlatforms, ImmutableMap<PlatformType, RichPerPushCounts> richPushPlatforms, DateTime time) {
        this.pushPlatforms = pushPlatforms;
        this.richPushPlatforms = richPushPlatforms;
        this.time = time;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public ImmutableMap<PlatformType, PerPushCounts> getPushPlatforms() {
        return this.pushPlatforms;
    }

    public ImmutableMap<PlatformType, RichPerPushCounts> getRichPushPlatforms() {
        return this.richPushPlatforms;
    }

    public DateTime getTime() {
        return this.time;
    }

    public String toString() {
        return "PlatformCounts{pushPlatforms=" + this.pushPlatforms + ", richPushPlatforms=" + this.richPushPlatforms + ", time=" + this.time + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.pushPlatforms, this.richPushPlatforms, this.time});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PlatformCounts other = (PlatformCounts)obj;
        return Objects.equal(this.pushPlatforms, other.pushPlatforms) && Objects.equal(this.richPushPlatforms, other.richPushPlatforms) && Objects.equal((Object)this.time, (Object)other.time);
    }

    public static class Builder {
        private ImmutableMap.Builder<PlatformType, PerPushCounts> pushPlatforms = ImmutableMap.builder();
        private ImmutableMap.Builder<PlatformType, RichPerPushCounts> richPushPlatforms = ImmutableMap.builder();
        private DateTime time;

        private Builder() {
        }

        public Builder addPlatform(PlatformType type, PerPushCounts count) {
            this.pushPlatforms.put((Object)type, (Object)count);
            return this;
        }

        public Builder addRichPlatform(PlatformType type, RichPerPushCounts count) {
            this.richPushPlatforms.put((Object)type, (Object)count);
            return this;
        }

        public Builder setTime(DateTime value) {
            this.time = value;
            return this;
        }

        public PlatformCounts build() {
            return new PlatformCounts(this.pushPlatforms.build(), this.richPushPlatforms.build(), this.time);
        }
    }
}

