/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SinglePushInfoResponse {
    private final UUID pushUUID;
    private final int directResponses;
    private final int sends;
    private final PushType pushType;
    private final DateTime pushTime;
    private final Optional<UUID> groupID;

    private SinglePushInfoResponse(UUID pushUUID, int directResponses, int sends, PushType pushType, DateTime pushTime, UUID groupID) {
        this.pushUUID = pushUUID;
        this.directResponses = directResponses;
        this.sends = sends;
        this.pushType = pushType;
        this.pushTime = pushTime;
        this.groupID = Optional.fromNullable((Object)groupID);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public UUID getPushUUID() {
        return this.pushUUID;
    }

    public int getDirectResponses() {
        return this.directResponses;
    }

    public int getSends() {
        return this.sends;
    }

    public PushType getPushType() {
        return this.pushType;
    }

    public DateTime getPushTime() {
        return this.pushTime;
    }

    public Optional<UUID> getGroupID() {
        return this.groupID;
    }

    public String toString() {
        return "SinglePushInfoResponse{pushUUID=" + this.pushUUID + ", directResponses=" + this.directResponses + ", sends=" + this.sends + ", pushType=" + (Object)((Object)this.pushType) + ", pushTime=" + this.pushTime + ", groupID=" + this.groupID + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.pushUUID, this.directResponses, this.sends, this.pushType, this.pushTime, this.groupID});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SinglePushInfoResponse other = (SinglePushInfoResponse)obj;
        return Objects.equal((Object)this.pushUUID, (Object)other.pushUUID) && Objects.equal((Object)this.directResponses, (Object)other.directResponses) && Objects.equal((Object)this.sends, (Object)other.sends) && Objects.equal((Object)((Object)this.pushType), (Object)((Object)other.pushType)) && Objects.equal((Object)this.pushTime, (Object)other.pushTime) && Objects.equal(this.groupID, other.groupID);
    }

    public static class Builder {
        private UUID pushUUID;
        private int directResponses;
        private int sends;
        private PushType pushType;
        private DateTime pushTime;
        private UUID groupID;

        private Builder() {
        }

        public Builder setPushUUID(UUID value) {
            this.pushUUID = value;
            return this;
        }

        public Builder setDirectResponses(int value) {
            this.directResponses = value;
            return this;
        }

        public Builder setSends(int value) {
            this.sends = value;
            return this;
        }

        public Builder setPushType(PushType value) {
            this.pushType = value;
            return this;
        }

        public Builder setPushTime(String value) {
            DateTime dt;
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
            this.pushTime = dt = formatter.parseDateTime(value);
            return this;
        }

        public Builder setGroupID(UUID value) {
            this.groupID = value;
            return this;
        }

        public SinglePushInfoResponse build() {
            Preconditions.checkNotNull((Object)this.pushUUID, (Object)"Push UUID cannot be null.");
            Preconditions.checkNotNull((Object)((Object)this.pushType), (Object)"Push Type cannot be null.");
            Preconditions.checkNotNull((Object)this.pushTime, (Object)"Push Time cannot be null.");
            return new SinglePushInfoResponse(this.pushUUID, this.directResponses, this.sends, this.pushType, this.pushTime, this.groupID);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PushType {
        UNICAST_PUSH,
        BROADCAST_PUSH,
        TAG_PUSH,
        SCHEDULED_PUSH;

    }
}

