/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.joda.time.DateTime;

public final class TimeInApp {
    private final float android;
    private final float ios;
    private final DateTime date;

    private TimeInApp(float android, float ios, DateTime date) {
        this.android = android;
        this.ios = ios;
        this.date = date;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public float getAndroid() {
        return this.android;
    }

    public float getIos() {
        return this.ios;
    }

    public DateTime getDate() {
        return this.date;
    }

    public String toString() {
        return "TimeInApp{android=" + this.android + ", ios=" + this.ios + ", date=" + this.date + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Float.valueOf(this.android), Float.valueOf(this.ios), this.date});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TimeInApp other = (TimeInApp)obj;
        return Objects.equal((Object)Float.valueOf(this.android), (Object)Float.valueOf(other.android)) && Objects.equal((Object)Float.valueOf(this.ios), (Object)Float.valueOf(other.ios)) && Objects.equal((Object)this.date, (Object)other.date);
    }

    public static class Builder {
        private float android;
        private float ios;
        private DateTime date;

        private Builder() {
        }

        public Builder setAndroid(float value) {
            this.android = value;
            return this;
        }

        public Builder setIOS(float value) {
            this.ios = value;
            return this;
        }

        public Builder setDate(DateTime value) {
            this.date = value;
            return this;
        }

        public TimeInApp build() {
            Preconditions.checkNotNull((Object)Float.valueOf(this.android));
            Preconditions.checkNotNull((Object)Float.valueOf(this.ios));
            Preconditions.checkNotNull((Object)this.date);
            return new TimeInApp(this.android, this.ios, this.date);
        }
    }
}

