/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.parse;

import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.DateFormats;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.reports.model.AppStats;
import java.io.IOException;
import org.codehaus.jackson.JsonParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AppStatsReader
implements JsonObjectReader<AppStats> {
    private final AppStats.Builder builder = AppStats.newBuilder();

    public void readStartTime(JsonParser jsonParser) throws IOException {
        String created = (String)jsonParser.readValueAs(String.class);
        this.builder.setStartTime(DateFormats.DATE_PARSER.parseDateTime(created));
    }

    public void readiOSCount(JsonParser jsonParser) throws IOException {
        this.builder.setIOSCount((Integer)jsonParser.readValueAs(Integer.class));
    }

    public void readBlackBerryCount(JsonParser jsonParser) throws IOException {
        this.builder.setBlackBerryCount((Integer)jsonParser.readValueAs(Integer.class));
    }

    public void readC2DMCount(JsonParser jsonParser) throws IOException {
        this.builder.setC2DMCount((Integer)jsonParser.readValueAs(Integer.class));
    }

    public void readGCMCount(JsonParser jsonParser) throws IOException {
        this.builder.setGCMCount((Integer)jsonParser.readValueAs(Integer.class));
    }

    public void readWindows8Count(JsonParser jsonParser) throws IOException {
        this.builder.setWindows8Count((Integer)jsonParser.readValueAs(Integer.class));
    }

    public void readWindowsPhone8Count(JsonParser jsonParser) throws IOException {
        this.builder.setWindowsPhone8Count((Integer)jsonParser.readValueAs(Integer.class));
    }

    @Override
    public AppStats validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage());
        }
    }
}

