/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.parse;

import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.DateFormats;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.reports.model.PerPushCounts;
import com.urbanairship.api.reports.model.PlatformCounts;
import com.urbanairship.api.reports.model.PlatformType;
import com.urbanairship.api.reports.model.RichPerPushCounts;
import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformCountsReader
implements JsonObjectReader<PlatformCounts> {
    private final PlatformCounts.Builder builder = PlatformCounts.newBuilder();

    public void readPlatformCounts(JsonParser jsonParser) throws IOException {
        Map obj = (Map)jsonParser.readValueAs((TypeReference)new TypeReference<Map<String, PerPushCounts>>(){});
        for (String s : obj.keySet()) {
            PlatformType type = (PlatformType)((Object)PlatformType.find(s).get());
            this.builder.addPlatform(type, (PerPushCounts)obj.get(s));
        }
    }

    public void readRichPlatformCounts(JsonParser jsonParser) throws IOException {
        Map obj = (Map)jsonParser.readValueAs((TypeReference)new TypeReference<Map<String, RichPerPushCounts>>(){});
        for (String s : obj.keySet()) {
            PlatformType type = (PlatformType)((Object)PlatformType.find(s).get());
            this.builder.addRichPlatform(type, (RichPerPushCounts)obj.get(s));
        }
    }

    public void readTime(JsonParser jsonParser) throws IOException {
        String created = (String)jsonParser.readValueAs(String.class);
        this.builder.setTime(DateFormats.DATE_PARSER.parseDateTime(created));
    }

    @Override
    public PlatformCounts validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage());
        }
    }
}

