/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.segments.model;

import com.google.common.base.Preconditions;
import com.urbanairship.api.client.APIResponseModelObject;
import com.urbanairship.api.segments.model.Operator;
import com.urbanairship.api.segments.model.Predicate;

public final class AudienceSegment
extends APIResponseModelObject {
    private final String displayName;
    private final Operator rootOperator;
    private final Predicate rootPredicate;
    private final Long count;

    private AudienceSegment(String displayName, Operator rootOperator, Predicate rootPredicate, Long count) {
        this.displayName = displayName;
        this.rootOperator = rootOperator;
        this.rootPredicate = rootPredicate;
        this.count = count;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isOperatorRoot() {
        return this.rootOperator != null;
    }

    public Operator getRootOperator() {
        return this.rootOperator;
    }

    public boolean isPredicateRoot() {
        return this.rootPredicate != null;
    }

    public Predicate getRootPredicate() {
        return this.rootPredicate;
    }

    public boolean hasCount() {
        return this.count != null;
    }

    public long getCount() {
        return this.count;
    }

    public Builder toBuilder() {
        return new Builder().setDisplayName(this.displayName).setRootOperator(this.rootOperator).setCount(this.count).setRootPredicate(this.rootPredicate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudienceSegment that = (AudienceSegment)o;
        if (this.count != null ? !this.count.equals(that.count) : that.count != null) {
            return false;
        }
        if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) {
            return false;
        }
        if (this.rootOperator != null ? !this.rootOperator.equals(that.rootOperator) : that.rootOperator != null) {
            return false;
        }
        return !(this.rootPredicate != null ? !this.rootPredicate.equals(that.rootPredicate) : that.rootPredicate != null);
    }

    public int hashCode() {
        int result = this.displayName != null ? this.displayName.hashCode() : 0;
        result = 31 * result + (this.rootOperator != null ? this.rootOperator.hashCode() : 0);
        result = 31 * result + (this.rootPredicate != null ? this.rootPredicate.hashCode() : 0);
        result = 31 * result + (this.count != null ? this.count.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AudienceSegment{displayName='" + this.displayName + '\'' + ", rootOperator=" + this.rootOperator + ", rootPredicate=" + this.rootPredicate + ", count=" + this.count + '}';
    }

    public static class Builder {
        private String displayName = null;
        private Operator rootOperator = null;
        private Predicate rootPredicate = null;
        private Long count = null;

        private Builder() {
        }

        public Builder setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder setRootOperator(Operator rootOperator) {
            this.rootOperator = rootOperator;
            return this;
        }

        public Builder setRootPredicate(Predicate rootPredicate) {
            this.rootPredicate = rootPredicate;
            return this;
        }

        public Builder setCount(Long count) {
            this.count = count;
            return this;
        }

        public AudienceSegment build() {
            Preconditions.checkNotNull((Object)this.displayName);
            Preconditions.checkArgument((this.rootOperator == null && this.rootPredicate != null || this.rootOperator != null && this.rootPredicate == null ? 1 : 0) != 0, (Object)"Must specify either a root operator or a root predicate");
            return new AudienceSegment(this.displayName, this.rootOperator, this.rootPredicate, this.count);
        }
    }
}

