/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.segments.model;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;

public final class LocationAlias {
    private final String aliasType;
    private final String aliasValue;

    public LocationAlias(String aliasType, String aliasValue) {
        this.aliasType = aliasType;
        this.aliasValue = aliasValue;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getAliasValue() {
        return this.aliasValue;
    }

    public String getAliasType() {
        return this.aliasType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationAlias alias = (LocationAlias)o;
        if (this.aliasType != null ? !this.aliasType.equals(alias.aliasType) : alias.aliasType != null) {
            return false;
        }
        return !(this.aliasValue != null ? !this.aliasValue.equals(alias.aliasValue) : alias.aliasValue != null);
    }

    public int hashCode() {
        int result = this.aliasType != null ? this.aliasType.hashCode() : 0;
        result = 31 * result + (this.aliasValue != null ? this.aliasValue.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "LocationAlias{aliasType='" + this.aliasType + '\'' + ", aliasValue='" + this.aliasValue + '\'' + '}';
    }

    public static class Builder {
        private String aliasType;
        private String aliasValue;

        private Builder() {
        }

        public Builder setAliasValue(String aliasValue) {
            this.aliasValue = aliasValue;
            return this;
        }

        public Builder setAliasType(String aliasType) {
            this.aliasType = aliasType;
            return this;
        }

        public LocationAlias build() {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.aliasType), (Object)"Alias type must be non empty string");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.aliasValue), (Object)"Alias name must be non empty string");
            return new LocationAlias(this.aliasType, this.aliasValue);
        }
    }
}

