/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.segments.model;

import com.urbanairship.api.segments.model.DateRange;
import com.urbanairship.api.segments.model.LocationIdentifier;
import com.urbanairship.api.segments.model.Predicate;
import com.urbanairship.api.segments.model.PresenceTimeframe;
import com.urbanairship.api.segments.model.RecentDateRange;

public final class LocationPredicate
implements Predicate {
    private final LocationIdentifier locationIdentifier;
    private final boolean recentDateRangeBounded;
    private final DateRange dateRange;
    private final RecentDateRange recentDateRange;
    private final PresenceTimeframe presenceTimeframe;

    public LocationPredicate(LocationIdentifier locationIdentifier, DateRange dateRange, PresenceTimeframe presenceTimeframe) {
        this(locationIdentifier, dateRange, false, null, presenceTimeframe);
    }

    public LocationPredicate(LocationIdentifier locationIdentifier, RecentDateRange recentDateRange, PresenceTimeframe presenceTimeframe) {
        this(locationIdentifier, null, true, recentDateRange, presenceTimeframe);
    }

    private LocationPredicate(LocationIdentifier locationIdentifier, DateRange dateRange, boolean recentDateRangeBounded, RecentDateRange recentDateRange, PresenceTimeframe presenceTimeframe) {
        this.dateRange = dateRange;
        this.locationIdentifier = locationIdentifier;
        this.recentDateRangeBounded = recentDateRangeBounded;
        this.recentDateRange = recentDateRange;
        this.presenceTimeframe = presenceTimeframe;
    }

    public String getName() {
        return "location";
    }

    public String getIdentifier() {
        return this.getName();
    }

    public LocationIdentifier getLocationIdentifier() {
        return this.locationIdentifier;
    }

    public DateRange getDateRange() {
        return this.dateRange;
    }

    public boolean isRecentDateRangeBounded() {
        return this.recentDateRangeBounded;
    }

    public RecentDateRange getRecentDateRange() {
        return this.recentDateRange;
    }

    public PresenceTimeframe getPresenceTimeframe() {
        return this.presenceTimeframe;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationPredicate predicate = (LocationPredicate)o;
        if (this.recentDateRangeBounded != predicate.recentDateRangeBounded) {
            return false;
        }
        if (this.dateRange != null ? !this.dateRange.equals(predicate.dateRange) : predicate.dateRange != null) {
            return false;
        }
        if (this.locationIdentifier != null ? !this.locationIdentifier.equals(predicate.locationIdentifier) : predicate.locationIdentifier != null) {
            return false;
        }
        if (this.presenceTimeframe != predicate.presenceTimeframe) {
            return false;
        }
        return !(this.recentDateRange != null ? !this.recentDateRange.equals(predicate.recentDateRange) : predicate.recentDateRange != null);
    }

    public int hashCode() {
        int result = this.locationIdentifier != null ? this.locationIdentifier.hashCode() : 0;
        result = 31 * result + (this.recentDateRangeBounded ? 1 : 0);
        result = 31 * result + (this.dateRange != null ? this.dateRange.hashCode() : 0);
        result = 31 * result + (this.recentDateRange != null ? this.recentDateRange.hashCode() : 0);
        result = 31 * result + (this.presenceTimeframe != null ? this.presenceTimeframe.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "LocationPredicate{dateRange=" + this.dateRange + ", locationIdentifier=" + this.locationIdentifier + ", recentDateRangeBounded=" + this.recentDateRangeBounded + ", recentDateRange=" + this.recentDateRange + ", presenceTimeframe=" + (Object)((Object)this.presenceTimeframe) + '}';
    }
}

