/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.segments.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.urbanairship.api.segments.model.OperatorChild;
import com.urbanairship.api.segments.model.OperatorType;
import com.urbanairship.api.segments.model.Predicate;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Operator {
    private final OperatorType type;
    private final List<OperatorChild> children;

    private Operator(OperatorType type, List<OperatorChild> children) {
        this.type = type;
        this.children = children;
    }

    public static Builder newBuilder(OperatorType type) {
        return new Builder(type);
    }

    public OperatorType getType() {
        return this.type;
    }

    public List<OperatorChild> getChildren() {
        return this.children;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Operator operator = (Operator)o;
        if (this.children != null ? !((Object)this.children).equals(operator.children) : operator.children != null) {
            return false;
        }
        return this.type == operator.type;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.children != null ? ((Object)this.children).hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Operator{type=" + (Object)((Object)this.type) + ", children=" + this.children + '}';
    }

    public static class Builder {
        private final OperatorType type;
        private final List<OperatorChild> children = Lists.newLinkedList();

        private Builder(OperatorType type) {
            this.type = type;
        }

        public Builder addPredicate(Predicate predicate) {
            this.children.add(new OperatorChild(predicate));
            return this;
        }

        public Builder addOperator(Operator operator) {
            this.children.add(new OperatorChild(operator));
            return this;
        }

        public Operator build() {
            Preconditions.checkArgument((!this.children.isEmpty() ? 1 : 0) != 0, (Object)"Operator must contain at least one predicate or operator child");
            Preconditions.checkArgument((this.type != OperatorType.NOT || this.children.size() == 1 ? 1 : 0) != 0, (Object)"A \"not\" operator can have only a single child being either another operator or a predicate");
            return new Operator(this.type, this.children);
        }
    }
}

