/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.segments.model;

import com.urbanairship.api.segments.model.Predicate;
import org.apache.commons.lang.StringUtils;

public final class TagPredicate
implements Predicate {
    public static final String DEFAULT_TAG_CLASS = "device";
    private final String tag;
    private final String tagClass;

    TagPredicate(String tag, String tagClass) {
        this.tag = tag;
        this.tagClass = tagClass;
    }

    public String getName() {
        return "tag";
    }

    public String getIdentifier() {
        return this.isDefaultClass() ? this.getName() : this.getName() + "/" + this.getTagClass();
    }

    public String getTag() {
        return this.tag;
    }

    public String getTagClass() {
        return this.tagClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagPredicate that = (TagPredicate)o;
        return !(this.tag != null ? !this.tag.equals(that.tag) : that.tag != null);
    }

    public int hashCode() {
        return this.tag != null ? this.tag.hashCode() : 0;
    }

    public String toString() {
        return "TagPredicate{tag='" + this.tag + '\'' + ", tagClass='" + this.tagClass + '\'' + '}';
    }

    public boolean isDefaultClass() {
        return StringUtils.isEmpty((String)this.tagClass) || DEFAULT_TAG_CLASS.equals(this.tagClass);
    }
}

