/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.segments.parse;

import com.urbanairship.api.segments.model.Operator;
import com.urbanairship.api.segments.model.OperatorType;
import com.urbanairship.api.segments.parse.InvalidAudienceSegmentException;
import com.urbanairship.api.segments.parse.PredicateDeserializer;
import java.io.IOException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperatorDeserializer
extends JsonDeserializer<Operator> {
    public static final OperatorDeserializer INSTANCE = new OperatorDeserializer(PredicateDeserializer.INSTANCE);
    private static final int MAX_OPERATOR_DEPTH = 10;
    private static final String INVALID_OPERATOR_PAYLOAD = "Operator elements must have an array of constraints";
    private static final String INVALID_OPERATOR = "Segment criteria operator elements must contain the type key and an array of child constraints";
    private static final String INVALID_NOT_OPERATOR = "A \"not\" operator must have a single child that is either another operator or a predicate";
    private static final String OPERATOR_DEPTH_EXCEEDED = "Operators can only be nested 10 levels deep";
    private static final String DOUBLE_NEGATIVE_OPERATOR = "The child of a not operator cannot be another not operator";
    private final OperatorChildrenDeserializerRegistry operatorChildrenDeserializerRegistry;

    private OperatorDeserializer(PredicateDeserializer predicateDeserializer) {
        this.operatorChildrenDeserializerRegistry = new OperatorChildrenDeserializerRegistry(this, predicateDeserializer);
    }

    public boolean isValidOperatorKey(String key) {
        return OperatorType.getOperatorTypeFromIdentifier(key) != null;
    }

    public Operator deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        return this.parseOperator(jp, ctxt, 1);
    }

    private Operator parseOperator(JsonParser jp, DeserializationContext ctxt, int depth) throws IOException {
        if (depth > 10) {
            throw new InvalidAudienceSegmentException(OPERATOR_DEPTH_EXCEEDED);
        }
        JsonToken token = jp.getCurrentToken();
        if (token == JsonToken.START_OBJECT) {
            token = jp.nextToken();
        }
        if (token != JsonToken.FIELD_NAME) {
            throw new InvalidAudienceSegmentException(INVALID_OPERATOR);
        }
        OperatorType operatorType = OperatorType.getOperatorTypeFromIdentifier(jp.getText());
        if (operatorType == null) {
            throw new InvalidAudienceSegmentException(INVALID_OPERATOR);
        }
        jp.nextToken();
        Operator operator = this.parseOperatorOfType(operatorType, jp, ctxt, depth);
        if (jp.nextToken() != JsonToken.END_OBJECT) {
            throw new InvalidAudienceSegmentException(INVALID_OPERATOR);
        }
        return operator;
    }

    private Operator parseOperatorOfType(OperatorType operatorType, JsonParser jp, DeserializationContext ctxt, int depth) throws IOException {
        Operator.Builder builder = Operator.newBuilder(operatorType);
        OperatorChildrenDeserializer childrenDeserializer = this.operatorChildrenDeserializerRegistry.getChildrenDeserializer(operatorType);
        childrenDeserializer.deserializeOperatorChildren(jp, ctxt, builder, depth);
        return builder.build();
    }

    private static class NotOperatorChildDeserializer
    implements OperatorChildrenDeserializer {
        private final OperatorDeserializer operatorDeserializer;
        private final PredicateDeserializer predicateDeserializer;

        private NotOperatorChildDeserializer(OperatorDeserializer operatorDeserializer, PredicateDeserializer predicateDeserializer) {
            this.operatorDeserializer = operatorDeserializer;
            this.predicateDeserializer = predicateDeserializer;
        }

        public void deserializeOperatorChildren(JsonParser jp, DeserializationContext ctxt, Operator.Builder builder, int depth) throws IOException {
            JsonToken token = jp.getCurrentToken();
            if (token != JsonToken.START_OBJECT) {
                throw new InvalidAudienceSegmentException(OperatorDeserializer.INVALID_NOT_OPERATOR);
            }
            token = jp.nextToken();
            if (token != JsonToken.FIELD_NAME) {
                throw new InvalidAudienceSegmentException(OperatorDeserializer.INVALID_NOT_OPERATOR);
            }
            String key = jp.getText();
            if (this.operatorDeserializer.isValidOperatorKey(key)) {
                if (OperatorType.NOT.getIdentifier().equals(key)) {
                    throw new InvalidAudienceSegmentException(OperatorDeserializer.DOUBLE_NEGATIVE_OPERATOR);
                }
                builder.addOperator(this.operatorDeserializer.parseOperator(jp, ctxt, depth + 1));
            } else {
                builder.addPredicate(this.predicateDeserializer.deserialize(jp, ctxt));
            }
        }
    }

    private static class StandardOperatorChildrenDeserializer
    implements OperatorChildrenDeserializer {
        private final OperatorDeserializer operatorDeserializer;
        private final PredicateDeserializer predicateDeserializer;

        private StandardOperatorChildrenDeserializer(OperatorDeserializer operatorDeserializer, PredicateDeserializer predicateDeserializer) {
            this.operatorDeserializer = operatorDeserializer;
            this.predicateDeserializer = predicateDeserializer;
        }

        public void deserializeOperatorChildren(JsonParser jp, DeserializationContext ctxt, Operator.Builder builder, int depth) throws IOException {
            int childrenRead = this.parseChildren(jp, ctxt, builder, depth);
            if (childrenRead == 0) {
                throw new InvalidAudienceSegmentException(OperatorDeserializer.INVALID_OPERATOR_PAYLOAD);
            }
        }

        private int parseChildren(JsonParser jp, DeserializationContext ctxt, Operator.Builder builder, int depth) throws IOException {
            JsonToken token = jp.getCurrentToken();
            if (token != JsonToken.START_ARRAY) {
                throw new InvalidAudienceSegmentException(OperatorDeserializer.INVALID_OPERATOR_PAYLOAD);
            }
            int childrenRead = 0;
            token = jp.nextToken();
            while (token != JsonToken.END_ARRAY) {
                if (token != JsonToken.START_OBJECT) {
                    throw new InvalidAudienceSegmentException("Operator elements must have an array of constraints. Location:" + jp.getCurrentLocation());
                }
                JsonToken childType = jp.nextToken();
                if (childType != JsonToken.FIELD_NAME) {
                    throw new InvalidAudienceSegmentException(OperatorDeserializer.INVALID_OPERATOR_PAYLOAD);
                }
                String constraintType = jp.getText();
                if (this.operatorDeserializer.isValidOperatorKey(constraintType)) {
                    builder.addOperator(this.operatorDeserializer.parseOperator(jp, ctxt, depth + 1));
                } else {
                    builder.addPredicate(this.predicateDeserializer.deserialize(jp, ctxt));
                }
                ++childrenRead;
                token = jp.nextToken();
            }
            return childrenRead;
        }
    }

    private static class OperatorChildrenDeserializerRegistry {
        private final NotOperatorChildDeserializer notOperatorChildDeserializer;
        private final StandardOperatorChildrenDeserializer standardOperatorChildrenDeserializer;

        private OperatorChildrenDeserializerRegistry(OperatorDeserializer operatorDeserializer, PredicateDeserializer predicateDeserializer) {
            this.notOperatorChildDeserializer = new NotOperatorChildDeserializer(operatorDeserializer, predicateDeserializer);
            this.standardOperatorChildrenDeserializer = new StandardOperatorChildrenDeserializer(operatorDeserializer, predicateDeserializer);
        }

        public OperatorChildrenDeserializer getChildrenDeserializer(OperatorType operatorType) {
            return operatorType == OperatorType.NOT ? this.notOperatorChildDeserializer : this.standardOperatorChildrenDeserializer;
        }
    }

    private static interface OperatorChildrenDeserializer {
        public void deserializeOperatorChildren(JsonParser var1, DeserializationContext var2, Operator.Builder var3, int var4) throws IOException;
    }
}

