/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.segments.parse;

import com.urbanairship.api.segments.model.TagPredicate;
import com.urbanairship.api.segments.model.TagPredicateBuilder;
import com.urbanairship.api.segments.parse.InvalidAudienceSegmentException;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagPredicateDeserializer
extends JsonDeserializer<TagPredicate> {
    public static final TagPredicateDeserializer INSTANCE = new TagPredicateDeserializer();
    private static final String INVALID_TAG_PREDICATE = "Invalid tag predicate";

    private TagPredicateDeserializer() {
    }

    public TagPredicate deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken token = jp.getCurrentToken();
        if (token != JsonToken.VALUE_STRING || StringUtils.isBlank((String)jp.getText())) {
            throw new InvalidAudienceSegmentException(INVALID_TAG_PREDICATE);
        }
        String tag = null;
        String tagClass = "device";
        if (jp.getCurrentName().equals("tag")) {
            tag = jp.getText();
        } else if (jp.getCurrentName().equals("tag_class")) {
            tagClass = jp.getText();
        }
        if (!jp.nextToken().equals((Object)JsonToken.END_OBJECT)) {
            if (jp.getCurrentName().equals("tag")) {
                jp.nextToken();
                tag = jp.getText();
            } else if (jp.getCurrentName().equals("tag_class")) {
                jp.nextToken();
                tagClass = jp.getText();
            }
        }
        return TagPredicateBuilder.newInstance().setTag(tag).setTagClass(tagClass).build();
    }
}

