/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.model.attributes;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.urbanairship.api.channel.model.attributes.AttributeAction;
import com.urbanairship.api.common.parse.DateFormats;
import java.util.Map;
import java.util.Optional;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class Attribute {
    private final AttributeAction action;
    private final String key;
    private final Optional<JsonNode> value;
    private final Optional<DateTime> timeStamp;

    private Attribute(Builder builder) {
        this.action = builder.action;
        this.key = builder.key;
        this.value = Optional.ofNullable(builder.value);
        this.timeStamp = Optional.ofNullable(builder.timeStamp);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public AttributeAction getAction() {
        return this.action;
    }

    public String getKey() {
        return this.key;
    }

    public Optional<JsonNode> getValue() {
        return this.value;
    }

    public Optional<DateTime> getTimeStamp() {
        return this.timeStamp;
    }

    public static class Builder {
        AttributeAction action;
        String key;
        JsonNode value;
        DateTime timeStamp;
        private static final ObjectMapper MAPPER = new ObjectMapper();

        public Builder setAction(AttributeAction action) {
            this.action = action;
            return this;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder setTimeStamp(DateTime timeStamp) {
            this.timeStamp = timeStamp;
            return this;
        }

        public Builder setValue(String value) {
            this.value = (JsonNode)MAPPER.convertValue((Object)value, JsonNode.class);
            return this;
        }

        public Builder setValue(Number value) {
            this.value = (JsonNode)MAPPER.convertValue((Object)value, JsonNode.class);
            return this;
        }

        public Builder setValue(Boolean value) {
            this.value = (JsonNode)MAPPER.convertValue((Object)value, JsonNode.class);
            return this;
        }

        public Builder setValue(DateTime value) {
            String formatted = DateFormats.DATE_FORMATTER.print((ReadableInstant)value);
            this.value = (JsonNode)MAPPER.convertValue((Object)formatted, JsonNode.class);
            return this;
        }

        public Builder setValue(JsonNode node) {
            this.value = node;
            return this;
        }

        public Builder setValue(Map<String, ?> map) {
            this.value = MAPPER.valueToTree(map);
            return this;
        }

        public Attribute build() {
            Preconditions.checkNotNull((Object)((Object)this.action), (Object)"Attribute action must be set.");
            Preconditions.checkNotNull((Object)this.key, (Object)"key must be set.");
            if (this.action.equals((Object)AttributeAction.SET)) {
                Preconditions.checkNotNull((Object)this.value, (Object)"Value must not be null when setting attributes");
            }
            return new Attribute(this);
        }
    }
}

