/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.createandsend;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.base.Preconditions;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.createandsend.model.notification.CreateAndSendPayload;
import com.urbanairship.api.push.model.PushResponse;
import com.urbanairship.api.push.parse.PushObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class CreateAndSendRequest
implements Request<PushResponse> {
    private static final String API_PUSH_PATH = "/api/create-and-send";
    private static final String API_VALIDATE_PATH = "/api/create-and-send/validate";
    private final List<CreateAndSendPayload> payloads = new ArrayList<CreateAndSendPayload>();
    private boolean validateOnly;

    private CreateAndSendRequest(CreateAndSendPayload payload) {
        Preconditions.checkNotNull((Object)payload, (Object)"Payload required when creating an email request");
        this.payloads.add(payload);
    }

    private CreateAndSendRequest(List<CreateAndSendPayload> payloadList) {
        Preconditions.checkNotNull(payloadList, (Object)"Payload required when creating a push request");
        if (payloadList.isEmpty()) {
            throw new IllegalStateException("Payload list cannot be empty");
        }
        this.payloads.addAll(payloadList);
    }

    public static CreateAndSendRequest newRequest(CreateAndSendPayload payload) {
        return new CreateAndSendRequest(payload);
    }

    public static CreateAndSendRequest newRequest(List<CreateAndSendPayload> payloadList) {
        return new CreateAndSendRequest(payloadList);
    }

    public CreateAndSendRequest addPayload(CreateAndSendPayload newPayload) {
        Preconditions.checkNotNull((Object)newPayload, (Object)"Payload required when adding to a CreateAndSendEmail request");
        this.payloads.add(newPayload);
        return this;
    }

    public CreateAndSendRequest addPayloads(List<CreateAndSendPayload> newPayloads) {
        Preconditions.checkNotNull(newPayloads, (Object)"Payload required when adding to a CreateAndSendEmail request");
        if (newPayloads.isEmpty()) {
            throw new IllegalStateException("Payload list cannot be empty");
        }
        this.payloads.addAll(newPayloads);
        return this;
    }

    public CreateAndSendRequest setValidateOnly(boolean validateOnly) {
        this.validateOnly = validateOnly;
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        if (this.payloads.size() == 1) {
            return this.payloads.get(0).toJSON();
        }
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode arrayNode = mapper.createArrayNode();
        for (CreateAndSendPayload pushPayload : this.payloads) {
            try {
                JsonNode pushJson = mapper.readTree(pushPayload.toJSON());
                arrayNode.add(pushJson);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return arrayNode.toString();
    }

    @Override
    public URI getUri(URI baseUri) {
        String path = this.validateOnly ? API_VALIDATE_PATH : API_PUSH_PATH;
        return RequestUtils.resolveURI(baseUri, path);
    }

    @Override
    public ResponseParser<PushResponse> getResponseParser() {
        return response -> (PushResponse)PushObjectMapper.getInstance().readValue(response, PushResponse.class);
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }
}

