/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.model.email;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.urbanairship.api.channel.model.ChannelType;
import com.urbanairship.api.channel.model.email.OptInLevel;
import com.urbanairship.api.channel.model.email.OptInMode;
import com.urbanairship.api.channel.model.email.TrackingOptInLevel;
import com.urbanairship.api.push.model.PushModelObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RegisterEmailChannel
extends PushModelObject {
    private final ChannelType type = ChannelType.EMAIL;
    private final Optional<Map<OptInLevel, String>> emailOptInLevel;
    private final String address;
    private final Optional<String> timezone;
    private final Optional<String> localeCountry;
    private final Optional<String> localeLanguage;
    private final Optional<OptInMode> emailOptInMode;
    private final Optional<Map<String, String>> properties;
    private final Optional<Map<TrackingOptInLevel, String>> trackingOptInLevel;
    private final Optional<Map<String, List<String>>> tags;
    private final Optional<Map<String, String>> attributes;

    protected RegisterEmailChannel(Builder builder) {
        this.emailOptInLevel = Optional.ofNullable(builder.emailOptInLevel);
        this.address = builder.address;
        this.timezone = Optional.ofNullable(builder.timezone);
        this.localeCountry = Optional.ofNullable(builder.localeCountry);
        this.localeLanguage = Optional.ofNullable(builder.localeLanguage);
        this.emailOptInMode = Optional.ofNullable(builder.emailOptInMode);
        this.properties = Optional.of(Collections.unmodifiableMap(builder.properties)).filter(map -> !map.isEmpty());
        this.trackingOptInLevel = Optional.of(Collections.unmodifiableMap(builder.trackingOptInLevel)).filter(map -> !map.isEmpty());
        this.tags = Optional.of(Collections.unmodifiableMap(builder.tags)).filter(map -> !map.isEmpty());
        this.attributes = Optional.of(Collections.unmodifiableMap(builder.attributes)).filter(map -> !map.isEmpty());
    }

    public ChannelType getType() {
        return ChannelType.EMAIL;
    }

    public Optional<Map<OptInLevel, String>> getEmailOptInLevel() {
        return this.emailOptInLevel;
    }

    public String getAddress() {
        return this.address;
    }

    public Optional<String> getTimezone() {
        return this.timezone;
    }

    public Optional<String> getLocaleCountry() {
        return this.localeCountry;
    }

    public Optional<String> getLocaleLanguage() {
        return this.localeLanguage;
    }

    public Optional<OptInMode> getEmailOptInMode() {
        return this.emailOptInMode;
    }

    public Optional<Map<String, String>> getProperties() {
        return this.properties;
    }

    public Optional<Map<TrackingOptInLevel, String>> getTrackingOptInLevel() {
        return this.trackingOptInLevel;
    }

    public Optional<Map<String, List<String>>> getTags() {
        return this.tags;
    }

    public Optional<Map<String, String>> getAttributes() {
        return this.attributes;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisterEmailChannel that = (RegisterEmailChannel)o;
        return this.type == that.type && Objects.equal((Object)this.address, (Object)that.address) && Objects.equal(this.timezone, that.timezone) && Objects.equal(this.localeCountry, that.localeCountry) && Objects.equal(this.localeLanguage, that.localeLanguage) && Objects.equal(this.emailOptInLevel, that.emailOptInLevel) && Objects.equal(this.emailOptInMode, that.emailOptInMode) && Objects.equal(this.properties, that.properties) && Objects.equal(this.trackingOptInLevel, that.trackingOptInLevel) && Objects.equal(this.tags, that.tags) && Objects.equal(this.attributes, that.attributes);
    }

    public String toString() {
        return "RegisterEmailChannel{type=" + (Object)((Object)this.type) + ", emailOptInLevel=" + this.emailOptInLevel + ", address=" + this.address + ", timezone=" + this.timezone + ", localeCountry=" + this.localeCountry + ", localeLanguage=" + this.localeLanguage + ", emailOptInMode=" + this.emailOptInMode + ", properties=" + this.properties + ", trackingOptInLevel=" + this.trackingOptInLevel + ", tags=" + this.tags + ", attributes=" + this.attributes + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.emailOptInLevel, this.address, this.timezone, this.localeCountry, this.localeLanguage, this.emailOptInMode, this.properties, this.trackingOptInLevel, this.tags, this.attributes});
    }

    public static final class Builder {
        private String address;
        private String timezone;
        private String localeCountry;
        private String localeLanguage;
        private Map<OptInLevel, String> emailOptInLevel = new HashMap<OptInLevel, String>();
        private OptInMode emailOptInMode;
        private Map<String, String> properties = new HashMap<String, String>();
        private Map<TrackingOptInLevel, String> trackingOptInLevel = new HashMap<TrackingOptInLevel, String>();
        private Map<String, List<String>> tags = new HashMap<String, List<String>>();
        private Map<String, String> attributes = new HashMap<String, String>();

        protected Builder() {
        }

        public Builder setEmailOptInLevel(OptInLevel level, String time) {
            this.emailOptInLevel.put(level, time);
            return this;
        }

        public Builder setTrackingOptInLevel(TrackingOptInLevel level, String time) {
            this.trackingOptInLevel.put(level, time);
            return this;
        }

        public Builder addTag(String group, String tag) {
            this.tags.computeIfAbsent(group, g -> new ArrayList()).add(tag);
            return this;
        }

        public Builder addAllTags(Map<String, List<String>> tags) {
            for (String group : tags.keySet()) {
                this.tags.computeIfAbsent(group, g -> new ArrayList()).addAll((Collection)tags.get(group));
            }
            return this;
        }

        public Builder addAttribute(String key, String value) {
            this.attributes.put(key, value);
            return this;
        }

        public Builder addAllAttributes(Map<String, String> attributes) {
            this.attributes.putAll(attributes);
            return this;
        }

        public Builder setAddress(String address) {
            this.address = address;
            return this;
        }

        public Builder setTimeZone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder setLocaleCountry(String locale_country) {
            this.localeCountry = locale_country;
            return this;
        }

        public Builder setLocaleLanguage(String locale_language) {
            this.localeLanguage = locale_language;
            return this;
        }

        public Builder setEmailOptInMode(OptInMode emailOptInMode) {
            this.emailOptInMode = emailOptInMode;
            return this;
        }

        public Builder addProperty(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        public Builder addAllProperties(Map<String, String> properties) {
            this.properties.putAll(properties);
            return this;
        }

        public RegisterEmailChannel build() {
            Preconditions.checkNotNull((Object)this.address, (Object)"address cannot be null.");
            Preconditions.checkNotNull(this.emailOptInLevel, (Object)"'emailOptInLevel' cannot be null.");
            return new RegisterEmailChannel(this);
        }
    }
}

