/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.parse.email;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.urbanairship.api.channel.model.email.OptInLevel;
import com.urbanairship.api.channel.model.email.RegisterEmailChannel;
import com.urbanairship.api.channel.model.email.TrackingOptInLevel;
import java.io.IOException;

public class RegisterEmailChannelSerializer
extends JsonSerializer<RegisterEmailChannel> {
    public void serialize(RegisterEmailChannel payload, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        String value;
        jgen.writeStartObject();
        jgen.writeObjectFieldStart("channel");
        jgen.writeStringField("type", payload.getType().getIdentifier());
        jgen.writeStringField("address", payload.getAddress());
        for (OptInLevel optInLevel : OptInLevel.values()) {
            if (!payload.getEmailOptInLevel().get().keySet().contains((Object)optInLevel) || (value = payload.getEmailOptInLevel().get().get((Object)optInLevel)) == null || value.isEmpty()) continue;
            jgen.writeObjectField(optInLevel.getIdentifier(), (Object)value);
        }
        if (payload.getTrackingOptInLevel().isPresent()) {
            for (Enum enum_ : TrackingOptInLevel.values()) {
                if (!payload.getTrackingOptInLevel().get().keySet().contains(enum_) || (value = payload.getTrackingOptInLevel().get().get(enum_)) == null || value.isEmpty()) continue;
                jgen.writeObjectField(((TrackingOptInLevel)enum_).getIdentifier(), (Object)value);
            }
        }
        if (payload.getTimezone().isPresent()) {
            jgen.writeStringField("timezone", payload.getTimezone().get());
        }
        if (payload.getLocaleCountry().isPresent()) {
            jgen.writeStringField("locale_country", payload.getLocaleCountry().get());
        }
        if (payload.getLocaleLanguage().isPresent()) {
            jgen.writeStringField("locale_language", payload.getLocaleLanguage().get());
        }
        jgen.writeEndObject();
        if (payload.getEmailOptInMode().isPresent()) {
            jgen.writeStringField("opt_in_mode", payload.getEmailOptInMode().get().getIdentifier());
        }
        if (payload.getProperties().isPresent()) {
            jgen.writeObjectFieldStart("properties");
            for (String key : payload.getProperties().get().keySet()) {
                jgen.writeStringField(key, payload.getProperties().get().get(key));
            }
            jgen.writeEndObject();
        }
        if (payload.getTags().isPresent()) {
            jgen.writeObjectFieldStart("tags");
            for (String group : payload.getTags().get().keySet()) {
                jgen.writeArrayFieldStart(group);
                for (String string : payload.getTags().get().get(group)) {
                    jgen.writeString(string);
                }
                jgen.writeEndArray();
            }
            jgen.writeEndObject();
        }
        if (payload.getAttributes().isPresent()) {
            jgen.writeObjectFieldStart("attributes");
            for (String key : payload.getAttributes().get().keySet()) {
                jgen.writeStringField(key, payload.getAttributes().get().get(key));
            }
            jgen.writeEndObject();
        }
        jgen.writeEndObject();
    }
}

