/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client.parse;

public class OAuthTokenResponse {
    private String accessToken;
    private long expiresIn;
    private long tokenAcquiredAt;
    private long tokenExpiresAt;

    public OAuthTokenResponse(String accessToken, long expiresIn) {
        this.accessToken = accessToken;
        this.expiresIn = expiresIn;
        this.tokenAcquiredAt = System.currentTimeMillis();
        this.tokenExpiresAt = this.tokenAcquiredAt + this.expiresIn * 1000L;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public long getExpiresIn() {
        return this.expiresIn;
    }

    public long getTokenAcquiredAt() {
        return this.tokenAcquiredAt;
    }

    public long getTokenExpiresAt() {
        return this.tokenExpiresAt;
    }

    public boolean isTokenExpired() {
        return System.currentTimeMillis() >= this.tokenExpiresAt;
    }
}

