/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.urbanairship.api.push.model.DeviceType;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.DevicePayloadOverride;
import com.urbanairship.api.push.model.notification.Interactive;
import com.urbanairship.api.push.model.notification.NotificationPayloadOverrideKey;
import com.urbanairship.api.push.model.notification.actions.Action;
import com.urbanairship.api.push.model.notification.actions.ActionNameRegistry;
import com.urbanairship.api.push.model.notification.actions.ActionType;
import com.urbanairship.api.push.model.notification.actions.Actions;
import com.urbanairship.api.push.model.notification.actions.AppDefinedAction;
import com.urbanairship.api.push.model.notification.ios.IOSDevicePayload;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

public final class Notification
extends PushModelObject {
    private final Optional<String> alert;
    private final ImmutableMap<NotificationPayloadOverrideKey, ? extends DevicePayloadOverride> deviceTypePayloadOverrides;
    private final Optional<Actions> actions;
    private final Optional<Interactive> interactive;

    private Notification(Optional<String> alert, ImmutableMap<NotificationPayloadOverrideKey, ? extends DevicePayloadOverride> deviceTypePayloadOverrides, Optional<Actions> actions, Optional<Interactive> interactive) {
        this.alert = alert;
        this.deviceTypePayloadOverrides = deviceTypePayloadOverrides;
        this.actions = actions;
        this.interactive = interactive;
    }

    public static Builder newBuilder() {
        return new Builder(ActionNameRegistry.INSTANCE);
    }

    public Builder toBuilder() {
        return Notification.newBuilder().mergeFrom(this);
    }

    public Optional<String> getAlert() {
        return this.alert;
    }

    public Optional<ImmutableSet<DeviceType>> getOverrideDeviceTypes() {
        if (this.deviceTypePayloadOverrides == null || this.deviceTypePayloadOverrides.size() == 0) {
            return Optional.empty();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (NotificationPayloadOverrideKey key : this.deviceTypePayloadOverrides.keySet()) {
            builder.add((Object)key.getDeviceType());
        }
        return Optional.of(builder.build());
    }

    public <O extends DevicePayloadOverride> Optional<O> getDeviceTypeOverride(DeviceType deviceType, Class<O> overrideType) {
        return Optional.ofNullable((DevicePayloadOverride)this.deviceTypePayloadOverrides.get((Object)new NotificationPayloadOverrideKey(deviceType, overrideType)));
    }

    public Map<DeviceType, DevicePayloadOverride> getDeviceTypePayloadOverrides() {
        HashMap overrides = Maps.newHashMap();
        for (Map.Entry entry : this.deviceTypePayloadOverrides.entrySet()) {
            overrides.put(((NotificationPayloadOverrideKey)entry.getKey()).getDeviceType(), entry.getValue());
        }
        return overrides;
    }

    public Optional<Actions> getActions() {
        return this.actions;
    }

    public Optional<Interactive> getInteractive() {
        return this.interactive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Notification that = (Notification)o;
        return Objects.equal(this.alert, that.alert) && Objects.equal(this.deviceTypePayloadOverrides, that.deviceTypePayloadOverrides) && Objects.equal(this.actions, that.actions) && Objects.equal(this.interactive, that.interactive);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.alert, this.deviceTypePayloadOverrides, this.actions, this.interactive});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("alert", this.alert).add("deviceTypePayloadOverrides", this.deviceTypePayloadOverrides).add("actions", this.actions).add("interactive", this.interactive).toString();
    }

    public static class Builder {
        private final ImmutableMap.Builder<NotificationPayloadOverrideKey, DevicePayloadOverride> deviceTypePayloadOverridesBuilder = ImmutableMap.builder();
        private final ActionNameRegistry registry;
        private String alert = null;
        private Actions actions = null;
        private Interactive interactive = null;

        private Builder(ActionNameRegistry registry) {
            this.registry = registry;
        }

        public Builder mergeFrom(Notification other) {
            if (other.getAlert().isPresent()) {
                this.setAlert(other.getAlert().get());
            }
            if (other.getActions().isPresent()) {
                this.setActions(other.getActions().get());
            }
            if (other.getInteractive().isPresent()) {
                this.setInteractive(other.getInteractive().get());
            }
            this.deviceTypePayloadOverridesBuilder.putAll((Map)other.deviceTypePayloadOverrides);
            return this;
        }

        public Builder setAlert(String alert) {
            this.alert = alert;
            return this;
        }

        public <P extends DevicePayloadOverride> Builder addDeviceTypeOverride(DeviceType deviceType, P payload) {
            this.deviceTypePayloadOverridesBuilder.put((Object)new NotificationPayloadOverrideKey(deviceType, payload.getClass()), payload);
            return this;
        }

        public Builder setActions(Actions actions) {
            this.actions = actions;
            return this;
        }

        public Builder setInteractive(Interactive interactive) {
            this.interactive = interactive;
            return this;
        }

        public Notification build() {
            ImmutableMap overrides = this.deviceTypePayloadOverridesBuilder.build();
            Preconditions.checkArgument((this.alert != null || !overrides.isEmpty() ? 1 : 0) != 0, (Object)"Must either specify default notification keys or at least a single deviceType override");
            IOSDevicePayload iOSOverride = (IOSDevicePayload)overrides.get((Object)new NotificationPayloadOverrideKey(DeviceType.IOS, IOSDevicePayload.class));
            if (this.actions != null && iOSOverride != null && iOSOverride.getExtra().isPresent()) {
                Map extras = (Map)iOSOverride.getExtra().get();
                for (Action action : this.actions.allActions()) {
                    if (action.getActionType() == ActionType.APP_DEFINED) {
                        Iterator fieldNames = ((AppDefinedAction)action).getValue().fieldNames();
                        while (fieldNames.hasNext()) {
                            String field = (String)fieldNames.next();
                            Preconditions.checkArgument((!extras.containsKey(field) ? 1 : 0) != 0, (Object)("The iOS extra key '" + field + "' cannot be present when an app_defined action field of the same name is present"));
                        }
                        continue;
                    }
                    String shortName = this.registry.getShortName(action.getActionType());
                    String longName = this.registry.getLongName(action.getActionType());
                    String fieldName = this.registry.getFieldName(action.getActionType());
                    Preconditions.checkArgument((!extras.containsKey(shortName) ? 1 : 0) != 0, (Object)("The iOS extras key '" + shortName + "' cannot be present when the action '" + fieldName + "' is present"));
                    Preconditions.checkArgument((!extras.containsKey(longName) ? 1 : 0) != 0, (Object)("The iOS extras key '" + longName + "' cannot be present when the action '" + fieldName + "' is present"));
                }
            }
            return new Notification(Optional.ofNullable(this.alert), overrides, Optional.ofNullable(this.actions), Optional.ofNullable(this.interactive));
        }
    }
}

