/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.web;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.web.WebFields;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
public class WebTemplate
extends PushModelObject {
    private final Optional<String> templateId;
    private final Optional<WebFields> webFields;

    private WebTemplate(Builder builder) {
        this.templateId = Optional.ofNullable(builder.templateId);
        this.webFields = Optional.ofNullable(builder.webFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="template_id")
    public Optional<String> getTemplateId() {
        return this.templateId;
    }

    @JsonProperty(value="fields")
    public Optional<WebFields> getWebFields() {
        return this.webFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebTemplate that = (WebTemplate)o;
        return Objects.equal(this.templateId, that.templateId) && Objects.equal(this.webFields, that.webFields);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.templateId, this.webFields});
    }

    public String toString() {
        return "WebTemplate{templateId=" + this.templateId + ", webFields=" + this.webFields + '}';
    }

    @JsonPOJOBuilder(withPrefix="set")
    public static class Builder {
        private String templateId = null;
        private WebFields webFields = null;

        @JsonProperty(value="template_id")
        public Builder setTemplateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        @JsonProperty(value="fields")
        public Builder setFields(WebFields webFields) {
            this.webFields = webFields;
            return this;
        }

        public WebTemplate build() {
            Preconditions.checkArgument((this.templateId == null || this.webFields == null ? 1 : 0) != 0, (Object)"templateID and ios fields cannot both be set.");
            return new WebTemplate(this);
        }
    }
}

