/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.staticlists;

import com.google.common.base.Preconditions;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.staticlists.model.StaticListView;
import com.urbanairship.api.staticlists.parse.StaticListsObjectMapper;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.ContentType;

public class StaticListLookupRequest
implements Request<StaticListView> {
    private static final String API_LISTS_PATH = "/api/lists/";
    private final String path;

    private StaticListLookupRequest(String path) {
        this.path = path;
    }

    public static StaticListLookupRequest newRequest(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)name), (Object)"List name cannot be null.");
        return new StaticListLookupRequest(API_LISTS_PATH + name);
    }

    @Override
    public ContentType getContentType() {
        return null;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.GET;
    }

    @Override
    public String getRequestBody() {
        return null;
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<StaticListView> getResponseParser() {
        return response -> (StaticListView)StaticListsObjectMapper.getInstance().readValue(response, StaticListView.class);
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }
}

