/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.nameduser;

import com.google.common.base.Preconditions;
import com.urbanairship.api.channel.model.ChannelType;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.nameduser.parse.NamedUserObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class NamedUserRequest
implements Request<String> {
    private static final String API_NAMED_USERS_ASSOCIATE = "/api/named_users/associate/";
    private static final String API_NAMED_USERS_DISASSOCIATE = "/api/named_users/disassociate/";
    private static final String CHANNEL_KEY = "channel_id";
    private static final String DEVICE_TYPE_KEY = "device_type";
    private static final String NAMED_USER_ID_KEY = "named_user_id";
    private final String path;
    private final Map<String, String> payload = new HashMap<String, String>();

    private NamedUserRequest(String path) {
        this.path = path;
    }

    public static NamedUserRequest newAssociationRequest() {
        return new NamedUserRequest(API_NAMED_USERS_ASSOCIATE);
    }

    public static NamedUserRequest newDisassociationRequest() {
        return new NamedUserRequest(API_NAMED_USERS_DISASSOCIATE);
    }

    public NamedUserRequest setChannel(String channelId, ChannelType channelType) {
        this.payload.put(CHANNEL_KEY, channelId);
        this.payload.put(DEVICE_TYPE_KEY, channelType.getIdentifier());
        return this;
    }

    public NamedUserRequest setNamedUserId(String namedUserId) {
        this.payload.put(NAMED_USER_ID_KEY, namedUserId);
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        Preconditions.checkArgument((!this.payload.isEmpty() ? 1 : 0) != 0, (Object)"Request payload cannot be empty");
        Preconditions.checkArgument((boolean)this.payload.containsKey(CHANNEL_KEY), (Object)"Channel ID required for named user association or disassociation requests");
        Preconditions.checkArgument((boolean)this.payload.containsKey(DEVICE_TYPE_KEY), (Object)"Device type required for named user association or disassociation requests");
        if (this.path.equals(API_NAMED_USERS_ASSOCIATE)) {
            Preconditions.checkArgument((boolean)this.payload.containsKey(NAMED_USER_ID_KEY), (Object)"Named User ID required for named user association requests");
        }
        try {
            return NamedUserObjectMapper.getInstance().writeValueAsString(this.payload);
        }
        catch (Exception e) {
            return "{ \"exception\" : \"" + e.getClass().getName() + "\", \"message\" : \"" + e.getMessage() + "\" }";
        }
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<String> getResponseParser() {
        return new ResponseParser<String>(){

            @Override
            public String parse(String response) throws IOException {
                return response;
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }
}

