/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.audience;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.push.model.DeviceType;
import com.urbanairship.api.push.model.DeviceTypeData;
import com.urbanairship.api.push.model.audience.SelectorType;
import com.urbanairship.api.push.model.audience.SelectorVisitor;
import com.urbanairship.api.push.model.audience.ValueSelector;
import java.util.Map;

public class BasicValueSelector
implements ValueSelector {
    private final SelectorType type;
    private final String value;
    private final Optional<Map<String, String>> attributes;

    protected BasicValueSelector(SelectorType type, String value, Optional<Map<String, String>> attributes) {
        this.type = type;
        this.value = value;
        this.attributes = attributes;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public SelectorType getType() {
        return this.type;
    }

    @Override
    public DeviceTypeData getApplicableDeviceTypes() {
        if (this.type.getPlatform().isPresent()) {
            return DeviceTypeData.of((DeviceType)((Object)this.type.getPlatform().get()));
        }
        return DeviceTypeData.all();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public Optional<Map<String, String>> getAttributes() {
        return this.attributes;
    }

    @Override
    public void accept(SelectorVisitor visitor) {
        visitor.enter(this);
        visitor.exit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicValueSelector that = (BasicValueSelector)o;
        if (this.type != null ? !this.type.equals((Object)that.type) : that.type != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return !(this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "BasicValueSelector{type=" + this.type.getIdentifier() + ",value=" + this.value + ",attributes=" + this.attributes + '}';
    }

    public static class Builder {
        private SelectorType type;
        private String value;
        private ImmutableMap.Builder<String, String> attributesBuilder;

        private Builder() {
        }

        public Builder setType(SelectorType value) {
            this.type = value;
            return this;
        }

        public Builder setValue(String value) {
            this.value = value;
            return this;
        }

        public Builder addAttribute(String key, String value) {
            if (this.attributesBuilder == null) {
                this.attributesBuilder = ImmutableMap.builder();
            }
            this.attributesBuilder.put((Object)key, (Object)value);
            return this;
        }

        public Builder addAllAttributes(Map<String, String> attributes) {
            if (this.attributesBuilder == null) {
                this.attributesBuilder = ImmutableMap.builder();
            }
            this.attributesBuilder.putAll(attributes);
            return this;
        }

        public BasicValueSelector build() {
            Preconditions.checkArgument((this.type != SelectorType.AND && this.type != SelectorType.OR && this.type != SelectorType.NOT ? 1 : 0) != 0, (Object)"Logical operators must have an array of one or more children.");
            Preconditions.checkArgument((this.type != SelectorType.ALL ? 1 : 0) != 0, (Object)"The 'all' selector cannot have a value.");
            Preconditions.checkArgument((this.type != SelectorType.TRIGGERED ? 1 : 0) != 0, (Object)"The 'triggered' selector cannot have a value.");
            ImmutableMap attributes = this.attributesBuilder != null ? this.attributesBuilder.build() : null;
            return new BasicValueSelector(this.type, this.value, (Optional<Map<String, String>>)Optional.fromNullable((Object)attributes));
        }
    }
}

