/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.urbanairship.api.channel.model.ios.IosSettings;
import com.urbanairship.api.channel.model.open.OpenChannel;
import com.urbanairship.api.channel.model.web.WebSettings;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;

public final class ChannelView {
    private final String channelId;
    private final String channelType;
    private final boolean installed;
    private final boolean optIn;
    private final Optional<Boolean> background;
    private final Optional<String> pushAddress;
    private final DateTime created;
    private final Optional<DateTime> lastRegistration;
    private final Optional<String> alias;
    private final ImmutableSet<String> tags;
    private final ImmutableMap<String, ImmutableSet<String>> tagGroups;
    private final Optional<IosSettings> iosSettings;
    private final Optional<WebSettings> web;
    private final Optional<OpenChannel> open;
    private final Optional<String> address;

    private ChannelView() {
        this(null, null, true, true, (Optional<Boolean>)Optional.absent(), (Optional<String>)Optional.absent(), null, (Optional<DateTime>)Optional.absent(), (Optional<String>)Optional.absent(), null, null, (Optional<IosSettings>)Optional.absent(), (Optional<WebSettings>)Optional.absent(), (Optional<OpenChannel>)Optional.absent(), (Optional<String>)Optional.absent());
    }

    private ChannelView(String channelId, String channelType, boolean installed, boolean optIn, Optional<Boolean> background, Optional<String> pushAddress, DateTime created, Optional<DateTime> lastRegistration, Optional<String> alias, ImmutableSet<String> tags, ImmutableMap<String, ImmutableSet<String>> tagGroups, Optional<IosSettings> iosSettings, Optional<WebSettings> web, Optional<OpenChannel> open, Optional<String> address) {
        this.channelId = channelId;
        this.channelType = channelType;
        this.installed = installed;
        this.optIn = optIn;
        this.background = background;
        this.pushAddress = pushAddress;
        this.created = created;
        this.lastRegistration = lastRegistration;
        this.alias = alias;
        this.tags = tags;
        this.tagGroups = tagGroups;
        this.iosSettings = iosSettings;
        this.web = web;
        this.open = open;
        this.address = address;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getChannelType() {
        return this.channelType;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public boolean isOptIn() {
        return this.optIn;
    }

    public Optional<Boolean> getBackground() {
        return this.background;
    }

    public Optional<String> getPushAddress() {
        return this.pushAddress;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public Optional<DateTime> getLastRegistration() {
        return this.lastRegistration;
    }

    public Optional<String> getAlias() {
        return this.alias;
    }

    public ImmutableSet<String> getTags() {
        return this.tags;
    }

    public ImmutableMap<String, ImmutableSet<String>> getTagGroups() {
        return this.tagGroups;
    }

    public Optional<IosSettings> getIosSettings() {
        return this.iosSettings;
    }

    public Optional<WebSettings> getWebSettings() {
        return this.web;
    }

    public Optional<OpenChannel> getOpen() {
        return this.open;
    }

    public Optional<String> getAddress() {
        return this.address;
    }

    public String toString() {
        return "ChannelView{channelId='" + this.channelId + '\'' + ", channelType='" + this.channelType + '\'' + ", installed=" + this.installed + ", optIn=" + this.optIn + ", background=" + this.background + ", pushAddress=" + this.pushAddress + ", created=" + this.created + ", lastRegistration=" + this.lastRegistration + ", alias=" + this.alias + ", tags=" + this.tags + ", tagGroups=" + this.tagGroups + ", iosSettings=" + this.iosSettings + ", web=" + this.web + ", open=" + this.open + ", address=" + this.address + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.channelId, this.channelType, this.installed, this.optIn, this.background, this.pushAddress, this.created, this.lastRegistration, this.alias, this.tags, this.tagGroups, this.iosSettings, this.web, this.open, this.address});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChannelView that = (ChannelView)o;
        return this.installed == that.installed && this.optIn == that.optIn && Objects.equal((Object)this.channelId, (Object)that.channelId) && Objects.equal((Object)this.channelType, (Object)that.channelType) && Objects.equal(this.background, that.background) && Objects.equal(this.pushAddress, that.pushAddress) && Objects.equal((Object)this.created, (Object)that.created) && Objects.equal(this.lastRegistration, that.lastRegistration) && Objects.equal(this.alias, that.alias) && Objects.equal(this.tags, that.tags) && Objects.equal(this.tagGroups, that.tagGroups) && Objects.equal(this.iosSettings, that.iosSettings) && Objects.equal(this.web, that.web) && Objects.equal(this.open, that.open) && Objects.equal(this.address, that.address);
    }

    public static final class Builder {
        private final ImmutableSet.Builder<String> tags = ImmutableSet.builder();
        private final ImmutableMap.Builder<String, ImmutableSet<String>> tagGroups = ImmutableMap.builder();
        private String channelId = null;
        private String channelType = null;
        private Boolean optIn = null;
        private Boolean installed = null;
        private Boolean background = null;
        private String pushAddress = null;
        private DateTime created = null;
        private DateTime lastRegistration = null;
        private String alias = null;
        private IosSettings iosSettings = null;
        private WebSettings webSettings = null;
        private OpenChannel openChannel = null;
        private String address = null;

        private Builder() {
        }

        public Builder setChannelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public Builder setChannelType(String channelType) {
            this.channelType = channelType;
            return this;
        }

        public Builder setInstalled(Boolean installed) {
            this.installed = installed;
            return this;
        }

        public Builder setOptIn(Boolean optIn) {
            this.optIn = optIn;
            return this;
        }

        public Builder setBackground(Boolean background) {
            this.background = background;
            return this;
        }

        public Builder setPushAddress(String pushAddress) {
            this.pushAddress = pushAddress;
            return this;
        }

        public Builder setCreated(DateTime created) {
            this.created = created;
            return this;
        }

        public Builder setLastRegistration(DateTime lastRegistration) {
            this.lastRegistration = lastRegistration;
            return this;
        }

        public Builder setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder addAllTags(Iterable<String> tags) {
            Preconditions.checkNotNull(tags);
            for (String tag : tags) {
                this.tags.add((Object)tag);
            }
            return this;
        }

        public Builder addTag(String tag) {
            if (StringUtils.isNotBlank((String)tag)) {
                this.tags.add((Object)tag);
            }
            return this;
        }

        public Builder addTagGroup(Map.Entry<String, ImmutableSet<String>> tagGroup) {
            if (!tagGroup.getKey().isEmpty()) {
                this.tagGroups.put(tagGroup);
            }
            return this;
        }

        public Builder addAllTagGroups(ImmutableMap<String, ImmutableSet<String>> tagGroups) {
            if (!tagGroups.isEmpty()) {
                this.tagGroups.putAll(tagGroups);
            }
            return this;
        }

        public Builder setIosSettings(IosSettings iosSettings) {
            this.iosSettings = iosSettings;
            return this;
        }

        public Builder setWebSettings(WebSettings webSettings) {
            this.webSettings = webSettings;
            return this;
        }

        public Builder setOpenChannel(OpenChannel openChannel) {
            this.openChannel = openChannel;
            return this;
        }

        public Builder setAddress(String address) {
            this.address = address;
            return this;
        }

        public ChannelView build() {
            Preconditions.checkNotNull((Object)this.channelId);
            Preconditions.checkNotNull((Object)this.channelType);
            Preconditions.checkNotNull((Object)this.installed);
            Preconditions.checkNotNull((Object)this.optIn);
            Preconditions.checkNotNull((Object)this.created);
            return new ChannelView(this.channelId, this.channelType, this.installed, this.optIn, Optional.fromNullable((Object)this.background), Optional.fromNullable((Object)this.pushAddress), this.created, Optional.fromNullable((Object)this.lastRegistration), Optional.fromNullable((Object)this.alias), this.tags.build(), this.tagGroups.build(), Optional.fromNullable((Object)this.iosSettings), Optional.fromNullable((Object)this.webSettings), Optional.fromNullable((Object)this.openChannel), Optional.fromNullable((Object)this.address));
        }
    }
}

