/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.customevents.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;

public class CustomEventResponse {
    private final Optional<String> operationId;
    private final boolean ok;

    public CustomEventResponse(String operationId, boolean ok) {
        this.operationId = Optional.fromNullable((Object)operationId);
        this.ok = ok;
    }

    public Optional<String> getOperationId() {
        return this.operationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomEventResponse that = (CustomEventResponse)o;
        return this.ok == that.ok && Objects.equal(this.operationId, that.operationId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.operationId, this.ok});
    }

    public boolean isOk() {
        return this.ok;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String operationId;
        private boolean ok = false;

        private Builder() {
        }

        public Builder addOperationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public Builder setOk(boolean ok) {
            this.ok = ok;
            return this;
        }

        public CustomEventResponse build() {
            return new CustomEventResponse(this.operationId, this.ok);
        }
    }
}

