/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.urbanairship.api.push.model.DeviceType;
import com.urbanairship.api.push.model.PushModelObject;

public final class DeviceTypeData
extends PushModelObject {
    private final boolean all;
    private final Optional<ImmutableSet<DeviceType>> deviceTypes;

    private DeviceTypeData(boolean all, Optional<ImmutableSet<DeviceType>> deviceTypes) {
        this.all = all;
        this.deviceTypes = deviceTypes;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static DeviceTypeData all() {
        return DeviceTypeData.newBuilder().setAll(true).build();
    }

    public static DeviceTypeData of(DeviceType ... deviceTypes) {
        Builder builder = DeviceTypeData.newBuilder();
        for (DeviceType p : deviceTypes) {
            builder.addDeviceType(p);
        }
        return builder.build();
    }

    public boolean isAll() {
        return this.all;
    }

    public Optional<ImmutableSet<DeviceType>> getDeviceTypes() {
        return this.deviceTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceTypeData that = (DeviceTypeData)o;
        if (this.all != that.all) {
            return false;
        }
        return !(this.deviceTypes == null ? that.deviceTypes != null : !this.deviceTypes.equals(that.deviceTypes));
    }

    public int hashCode() {
        int result = this.deviceTypes != null ? this.deviceTypes.hashCode() : 0;
        result = 31 * result + (this.all ? 1 : 0);
        return result;
    }

    public String toString() {
        return "DeviceTypeData{all=" + this.all + ", deviceTypes=" + this.deviceTypes + '}';
    }

    public static class Builder {
        private boolean all = false;
        private ImmutableSet.Builder<DeviceType> deviceTypes = null;

        private Builder() {
        }

        public Builder setAll(boolean value) {
            this.all = value;
            return this;
        }

        public Builder addDeviceType(DeviceType deviceType) {
            if (this.deviceTypes == null) {
                this.deviceTypes = ImmutableSet.builder();
            }
            this.deviceTypes.add((Object)deviceType);
            return this;
        }

        public Builder addAllDeviceTypes(Iterable<DeviceType> deviceTypes) {
            if (this.deviceTypes == null) {
                this.deviceTypes = ImmutableSet.builder();
            }
            this.deviceTypes.addAll(deviceTypes);
            return this;
        }

        public DeviceTypeData build() {
            Preconditions.checkArgument((!this.all || this.deviceTypes == null ? 1 : 0) != 0, (Object)"'device_types' cannot be both 'all' and a list of device types.");
            return new DeviceTypeData(this.all, this.deviceTypes == null ? Optional.absent() : Optional.fromNullable((Object)this.deviceTypes.build()));
        }
    }
}

