/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse;

import com.fasterxml.jackson.core.JsonParser;
import com.google.common.base.Optional;
import com.urbanairship.api.client.UrbanAirshipClient;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.push.model.Display;
import com.urbanairship.api.push.model.Position;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisplayReader
implements JsonObjectReader<Display> {
    private static final Logger log = LoggerFactory.getLogger(UrbanAirshipClient.class);
    private final Display.Builder builder = Display.newBuilder();

    public void readPrimaryColor(JsonParser parser) throws IOException {
        this.builder.setPrimaryColor((String)parser.readValueAs(String.class));
    }

    public void readSecondaryColor(JsonParser parser) throws IOException {
        this.builder.setSecondaryColor((String)parser.readValueAs(String.class));
    }

    public void readDuration(JsonParser parser) throws IOException {
        this.builder.setDuration((Integer)parser.readValueAs(Integer.class));
    }

    public void readPosition(JsonParser parser) throws IOException {
        String positionString = parser.getText();
        Optional<Position> positionOpt = Position.find(positionString);
        if (!positionOpt.isPresent()) {
            log.error("Unrecognized position " + positionString);
            return;
        }
        this.builder.setPosition((Position)((Object)positionOpt.get()));
    }

    @Override
    public Display validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage());
        }
    }
}

