/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.parse;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.urbanairship.api.push.parse.PushObjectMapper;
import com.urbanairship.api.reports.model.PlatformStats;
import com.urbanairship.api.reports.model.PlatformStatsResponse;
import com.urbanairship.api.reports.model.PushInfoResponse;
import com.urbanairship.api.reports.model.PushListingResponse;
import com.urbanairship.api.reports.model.StatisticsResponse;
import com.urbanairship.api.reports.parse.PlatformStatsDeserializer;
import com.urbanairship.api.reports.parse.PlatformStatsResponseDeserializer;
import com.urbanairship.api.reports.parse.PushInfoResponseDeserializer;
import com.urbanairship.api.reports.parse.PushListingResponseDeserializer;
import com.urbanairship.api.reports.parse.StatisticsResponseDeserializer;

public class ReportsObjectMapper {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final SimpleModule MODULE = new SimpleModule("Reports API Module", new Version(1, 0, 0, null));

    public static SimpleModule getModule() {
        return MODULE;
    }

    public static ObjectMapper getInstance() {
        return MAPPER;
    }

    private ReportsObjectMapper() {
    }

    static {
        MODULE.addDeserializer(PushInfoResponse.class, (JsonDeserializer)new PushInfoResponseDeserializer());
        MODULE.addDeserializer(PushListingResponse.class, (JsonDeserializer)new PushListingResponseDeserializer());
        MODULE.addDeserializer(StatisticsResponse.class, (JsonDeserializer)new StatisticsResponseDeserializer());
        MODULE.addDeserializer(PlatformStats.class, (JsonDeserializer)new PlatformStatsDeserializer());
        MODULE.addDeserializer(PlatformStatsResponse.class, (JsonDeserializer)new PlatformStatsResponseDeserializer());
        MAPPER.registerModule((Module)MODULE);
        MAPPER.registerModule((Module)PushObjectMapper.getModule());
    }
}

