/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.schedule.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.schedule.model.SchedulePayload;

public final class ScheduleResponse {
    private final boolean ok;
    private final String operationId;
    private final ImmutableList<String> scheduleUrls;
    private final ImmutableList<String> scheduleIds;
    private final ImmutableList<SchedulePayload> schedulePayloads;

    private ScheduleResponse(boolean ok, String operationId, ImmutableList<String> scheduleUrls, ImmutableList<String> scheduleIds, ImmutableList<SchedulePayload> schedulePayloads) {
        this.ok = ok;
        this.operationId = operationId;
        this.scheduleUrls = scheduleUrls;
        this.scheduleIds = scheduleIds;
        this.schedulePayloads = schedulePayloads;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean getOk() {
        return this.ok;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public ImmutableList<String> getScheduleUrls() {
        return this.scheduleUrls;
    }

    public ImmutableList<String> getScheduleIds() {
        return this.scheduleIds;
    }

    public ImmutableList<SchedulePayload> getSchedulePayloads() {
        return this.schedulePayloads;
    }

    public String toString() {
        return "ScheduleResponse{ok=" + this.ok + ", operationId='" + this.operationId + '\'' + ", scheduleUrls=" + this.scheduleUrls + ", scheduleIds=" + this.scheduleIds + ", schedulePayloads=" + this.schedulePayloads + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ok, this.operationId, this.scheduleUrls, this.scheduleIds, this.schedulePayloads});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ScheduleResponse other = (ScheduleResponse)obj;
        return Objects.equal((Object)this.ok, (Object)other.ok) && Objects.equal((Object)this.operationId, (Object)other.operationId) && Objects.equal(this.scheduleUrls, other.scheduleUrls) && Objects.equal(this.scheduleIds, other.scheduleIds) && Objects.equal(this.schedulePayloads, other.schedulePayloads);
    }

    public static class Builder {
        private boolean ok;
        private String operationId;
        private ImmutableList.Builder<String> scheduleUrls = ImmutableList.builder();
        private ImmutableList.Builder<String> scheduleIds = ImmutableList.builder();
        private ImmutableList.Builder<SchedulePayload> schedulePayloads = ImmutableList.builder();

        private Builder() {
        }

        public Builder setOk(boolean ok) {
            this.ok = ok;
            return this;
        }

        public Builder setOperationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public Builder addScheduleUrl(String scheduleurl) {
            this.scheduleUrls.add((Object)scheduleurl);
            return this;
        }

        public Builder addAllScheduleUrls(Iterable<? extends String> scheduleUrls) {
            this.scheduleUrls.addAll(scheduleUrls);
            return this;
        }

        public Builder addScheduleId(String scheduleId) {
            this.scheduleIds.add((Object)scheduleId);
            return this;
        }

        public Builder addAllScheduleIds(Iterable<? extends String> scheduleIds) {
            this.scheduleIds.addAll(scheduleIds);
            return this;
        }

        public Builder addSchedulePayload(SchedulePayload schedulePayload) {
            this.schedulePayloads.add((Object)schedulePayload);
            return this;
        }

        public Builder addAllSchedulePayload(Iterable<? extends SchedulePayload> schedulePayloads) {
            this.schedulePayloads.addAll(schedulePayloads);
            return this;
        }

        public ScheduleResponse build() {
            Preconditions.checkNotNull((Object)this.ok, (Object)"The ok attribute must be set in order to build ScheduleResponse");
            Preconditions.checkNotNull((Object)this.operationId, (Object)"Operation ID must be set in order to build ScheduleResponse");
            return new ScheduleResponse(this.ok, this.operationId, this.scheduleUrls.build(), this.scheduleIds.build(), this.schedulePayloads.build());
        }
    }
}

