/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.model.email;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public final class EmailChannelResponse {
    private final boolean ok;
    private final Optional<String> channelId;

    private EmailChannelResponse(boolean ok, String channelId) {
        this.ok = ok;
        this.channelId = Optional.fromNullable((Object)channelId);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean getOk() {
        return this.ok;
    }

    public Optional<String> getChannelId() {
        return this.channelId;
    }

    public String toString() {
        return "APIListAllChannelsResponse{ok=" + this.ok + ", channelId=" + this.channelId + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ok, this.channelId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EmailChannelResponse other = (EmailChannelResponse)obj;
        return Objects.equal((Object)this.ok, (Object)other.ok) && Objects.equal(this.channelId, other.channelId);
    }

    public static class Builder {
        private boolean ok;
        private String channelId = null;

        private Builder() {
        }

        public Builder setOk(boolean value) {
            this.ok = value;
            return this;
        }

        public Builder setChannelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public EmailChannelResponse build() {
            if (this.ok) {
                Preconditions.checkArgument((this.channelId != null ? 1 : 0) != 0);
            }
            return new EmailChannelResponse(this.ok, this.channelId);
        }
    }
}

