/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.email;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.DeviceType;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.DevicePayloadOverride;
import com.urbanairship.api.push.model.notification.email.MessageType;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class EmailPayload
extends PushModelObject
implements DevicePayloadOverride {
    private final Optional<String> alert;
    private final Optional<String> subject;
    private final Optional<String> htmlBody;
    private final Optional<String> plaintextBody;
    private final Optional<MessageType> messageType;
    private final Optional<String> senderName;
    private final Optional<String> senderAddress;
    private final Optional<String> uaAddress;
    private final Optional<String> replyTo;
    private final DeviceType deviceType;

    private EmailPayload(Builder builder) {
        this.alert = Optional.fromNullable((Object)builder.alert);
        this.subject = Optional.fromNullable((Object)builder.subject);
        this.htmlBody = Optional.fromNullable((Object)builder.htmlBody);
        this.plaintextBody = Optional.fromNullable((Object)builder.plaintextBody);
        this.messageType = Optional.fromNullable((Object)((Object)builder.messageType));
        this.senderName = Optional.fromNullable((Object)builder.senderName);
        this.senderAddress = Optional.fromNullable((Object)builder.senderAddress);
        this.uaAddress = Optional.fromNullable((Object)builder.uaAddress);
        this.replyTo = Optional.fromNullable((Object)builder.replyTo);
        this.deviceType = builder.deviceType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.EMAIL;
    }

    @Override
    public Optional<String> getAlert() {
        return this.alert;
    }

    public Optional<String> getSubject() {
        return this.subject;
    }

    public Optional<String> getHtmlBody() {
        return this.htmlBody;
    }

    public Optional<String> getPlaintextBody() {
        return this.plaintextBody;
    }

    public Optional<MessageType> getMessageType() {
        return this.messageType;
    }

    public Optional<String> getSenderName() {
        return this.senderName;
    }

    public Optional<String> getSenderAddress() {
        return this.senderAddress;
    }

    public Optional<String> getUaAddress() {
        return this.uaAddress;
    }

    public Optional<String> getReplyTo() {
        return this.replyTo;
    }

    public String toString() {
        return "EmailPayload{subject=" + this.subject + ", htmlBody=" + this.htmlBody + ", plaintextBody=" + this.plaintextBody + ", messageType=" + this.messageType + ", senderName=" + this.senderName + ", senderAddress=" + this.senderAddress + ", uaAddress=" + this.uaAddress + ", replyTo=" + this.replyTo + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmailPayload)) {
            return false;
        }
        EmailPayload that = (EmailPayload)o;
        return Objects.equals(this.getSubject(), that.getSubject()) && Objects.equals(this.getHtmlBody(), that.getHtmlBody()) && Objects.equals(this.getPlaintextBody(), that.getPlaintextBody()) && Objects.equals(this.getMessageType(), that.getMessageType()) && Objects.equals(this.getSenderName(), that.getSenderName()) && Objects.equals(this.getSenderAddress(), that.getSenderAddress()) && Objects.equals(this.getUaAddress(), that.getUaAddress()) && Objects.equals(this.getReplyTo(), that.getReplyTo());
    }

    public int hashCode() {
        return Objects.hash(this.getSubject(), this.getHtmlBody(), this.getPlaintextBody(), this.getMessageType(), this.getSenderName(), this.getSenderAddress(), this.getUaAddress(), this.getReplyTo());
    }

    public static class Builder {
        private String alert = null;
        private String subject = null;
        private String htmlBody = null;
        private String plaintextBody = null;
        private MessageType messageType = null;
        private String senderName = null;
        private String senderAddress = null;
        private String uaAddress = null;
        private String replyTo = null;
        private DeviceType deviceType = null;

        private Builder() {
        }

        public Builder setSubject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder setHtmlBody(String htmlBody) {
            this.htmlBody = htmlBody;
            return this;
        }

        public Builder setPlaintextBody(String plaintextBody) {
            this.plaintextBody = plaintextBody;
            return this;
        }

        public Builder setMessageType(MessageType value) {
            this.messageType = value;
            return this;
        }

        public Builder setSenderAddress(String senderAddress) {
            this.senderAddress = senderAddress;
            return this;
        }

        public Builder setUaAddress(String uaAddress) {
            this.uaAddress = uaAddress;
            return this;
        }

        public Builder setReplyTo(String replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public Builder setSenderName(String senderName) {
            this.senderName = senderName;
            return this;
        }

        public Builder setDeviceType(DeviceType deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public EmailPayload build() {
            Preconditions.checkNotNull((Object)this.deviceType, (Object)"DeviceType must be set.");
            Preconditions.checkNotNull((Object)this.subject, (Object)"Subject must be set.");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.subject), (Object)"Subject must not be blank");
            Preconditions.checkNotNull((Object)this.plaintextBody, (Object)"PlaintextBody must be set.");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.plaintextBody), (Object)"Plaintext Body must not be blank");
            Preconditions.checkNotNull((Object)((Object)this.messageType), (Object)"MessageType must be set.");
            Preconditions.checkNotNull((Object)this.senderName, (Object)"SenderName must be set.");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.senderName), (Object)"SenderName must not be blank");
            Preconditions.checkNotNull((Object)this.senderAddress, (Object)"SenderAddress must be set.");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.senderAddress), (Object)"SenderAddress must not be blank");
            Preconditions.checkNotNull((Object)this.replyTo, (Object)"ReplyTo must be set.");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.replyTo), (Object)"ReplyTo must not be blank");
            return new EmailPayload(this);
        }
    }
}

