/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.push.model.Display;
import com.urbanairship.api.push.model.InApp;
import com.urbanairship.api.push.model.notification.Interactive;
import com.urbanairship.api.push.model.notification.actions.Actions;
import java.io.IOException;
import java.util.Map;
import org.joda.time.DateTime;

public class InAppReader
implements JsonObjectReader<InApp> {
    private final InApp.Builder builder = InApp.newBuilder();

    public void readAlert(JsonParser parser) throws IOException {
        this.builder.setAlert((String)parser.readValueAs(String.class));
    }

    public void readExpiry(JsonParser parser) throws IOException {
        this.builder.setExpiry((DateTime)parser.readValueAs(DateTime.class));
    }

    public void readDisplay(JsonParser parser) throws IOException {
        this.builder.setDisplay((Display)parser.readValueAs(Display.class));
    }

    public void readActions(JsonParser parser) throws IOException {
        this.builder.setActions((Actions)parser.readValueAs(Actions.class));
    }

    public void readInteractive(JsonParser parser) throws IOException {
        this.builder.setInteractive((Interactive)parser.readValueAs(Interactive.class));
    }

    public void readAllExtras(JsonParser parser) throws IOException {
        Map mutableExtras = (Map)parser.readValueAs((TypeReference)new TypeReference<Map<String, String>>(){});
        ImmutableMap<String, String> extras = InAppReader.immutableMapConverter(mutableExtras);
        this.builder.addAllExtras((Map<String, String>)extras);
    }

    @Override
    public InApp validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage());
        }
    }

    private static ImmutableMap<String, String> immutableMapConverter(Map<String, String> map) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        return builder.build();
    }
}

